import QtQuick 1.0

Text {
    id: root

    property Style platformStyle: LabelStyle {}
    property int maximumLineCount: -1

    QtObject {
        id: internal

        function clipText() {
            height = maximumLineCount * (font.pixelSize * 1.3);
            clip = true;
        }
    }

    color: enabled ? platformStyle.textColor : platformStyle.disabledTextColor
    font.family: platformStyle.fontFamily
    font.pixelSize: platformStyle.fontSizeNormal
    onTextChanged: if (maximumLineCount > 0 ) internal.clipText();
}
