import QtQuick 1.0
import "CreateObject.js" as ObjectCreator

Row {
    id: root

    property bool exclusive: false
    property Item checkedButton

    QtObject {
        id: internal

        function setUpButton(button, index, len) {
            var style = ObjectCreator.createObject(Qt.resolvedUrl("ButtonRowStyle.qml"), button);
            style.buttonIndex = index;
            style.buttonRowLength = len;
            button.platformStyle = style;
            button.checkable = root.exclusive;
            button.__exclusive = root.exclusive;
            button.checkChanged.connect(internal.setCheckedButton);

            if (button.checked) {
                internal.setCheckedButton(button);
            }
        }

        function update() {
            for (var i = 1; i <= root.children.length; i++) {
                internal.setUpButton(root.children[i - 1], i, root.children.length);
            }
        }

        function setCheckedButton(button) {
            if (button.checked) {
                root.checkedButton = button;
            }

            for (var i = 0; i < root.children.length; i++) {
                if (root.children[i] !== root.checkedButton) {
                    root.children[i].checked = false;
                }
            }
        }
    }

    objectName: "__buttonRow"
    onExclusiveChanged: internal.update()

    Component.onCompleted: internal.update()

    Component.onDestruction: {
        for (var i = 0; i < children.length; i++) {
            children[i].checkChanged.disconnect(internal.setCheckedButton);
        }
    }
}
