//callbacks.h: libspotify callbacks
#ifndef CALLBACKS_H
#define CALLBACKS_H

#include "spotifysession.h"

// libspotify callback functions

sp_session_callbacks g_callbacks = {
    &Spotify::Session::loggedInCallback,
    &Spotify::Session::loggedOutCallback,
    &Spotify::Session::metadataUpdatedCallback,
    &Spotify::Session::connectionErrorCallback,
    &Spotify::Session::messageToUserCallback,
    &Spotify::Session::notifyMainThreadCallback,
    &Spotify::Session::musicDeliveryCallback,
    &Spotify::Session::playTokenLostCallback,
    &Spotify::Session::logMessageCallback,
    &Spotify::Session::endOfTrackCallback,
    &Spotify::Session::streamingError,
    NULL,
    NULL,
    NULL,
    NULL,
    &Spotify::Session::offlineStatusUpdated,
    &Spotify::Session::offlineSynchronistationError
};

//Playlist container callbacks
sp_playlistcontainer_callbacks pc_callbacks = {
    &Spotify::Session::playlistAddedCallback,
    &Spotify::Session::playlistRemovedCallback,
    NULL,
    &Spotify::Session::playListContainerLoadedCallback
};

#endif // CALLBACKS_H
