//ConnectionManager.cpp: Implementation of the ConnectionManager class.

#include "connectionmanager.h"

ConnectionManager::ConnectionManager(QObject *pParent)
    : QObject(pParent)
{
    //constructor; initialise current network configuration / session etc.
   m_currNetworkStatus=QSystemNetworkInfo::UndefinedStatus;
   m_pNetInfo = new QSystemNetworkInfo(this);
   m_pNetSess = NULL;
   connect(&m_netConfMan,SIGNAL(onlineStateChanged(bool)),SLOT(OnOnlineStateChanged(bool)));
}

bool ConnectionManager::attemptConnect()
{
    //Attempt to establish internet connection using default configuration. Return true on success; false on failure.
    bool canStartIAP = (m_netConfMan.capabilities() & QNetworkConfigurationManager::CanStartAndStopInterfaces);
    //Use default configuration (if available)
    m_activeNetConf = m_netConfMan.defaultConfiguration();
    if (!m_activeNetConf.isValid() || (!canStartIAP && m_activeNetConf.state() != QNetworkConfiguration::Active))
    {
        //no default config / active connection available
        return false;
    }

    if(!m_pNetSess)
    {
          m_pNetSess = new QNetworkSession(m_activeNetConf, this);
    }

    m_pNetSess->open(); //request to open network session
    if(!m_pNetSess->waitForOpened(-1)) //blocking wait
    {
        return false; //failure
    }
    return true; //successfully established network session
}

ConnectionManager::~ConnectionManager()
{
}

void ConnectionManager::OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode mode, QSystemNetworkInfo::NetworkStatus newStatus)
{
    qDebug() << "Mode: " << mode << ", status: " << newStatus;
    if(newStatus==QSystemNetworkInfo::Connected && m_currNetworkStatus==QSystemNetworkInfo::NoNetworkAvailable) //new network status is Connected; send reconnect req.
      emit reconnectRequired();
    m_currNetworkStatus=newStatus;
}

bool ConnectionManager::currOnlineState()
{
    //Return true if current state is online; otherwise returns false (offline)
    return m_netConfMan.isOnline();
}

void ConnectionManager::OnOnlineStateChanged(bool isOnline)
{
    //notification that current active network config's online state has changed.
    emit onlineStateChanged(isOnline);
}

QNetworkConfiguration::BearerType ConnectionManager::bearerType()
{ //return the type of currently active bearer
    QList<QNetworkConfiguration> configs = m_netConfMan.allConfigurations(QNetworkConfiguration::Active);

    if(configs.size()>0)
        return configs.at(0).bearerType();
    else
        return QNetworkConfiguration::BearerUnknown;
}

bool ConnectionManager::roamingSupported()
{
    //Return true in case current bearer supports roaming
    QList<QNetworkConfiguration> configs = m_netConfMan.allConfigurations(QNetworkConfiguration::Active);
    if(configs.size()>0)
        return configs.at(0).isRoamingAvailable();
    else
        return false;
}

void ConnectionManager::OnNewConfigActivated()
{
    //new network config activated for current session
    qDebug() << "New config activated";
}

void ConnectionManager::OnSessionStateChanged(QNetworkSession::State newState)
{
//notification about session state change
    qDebug() << "Session state change: " << newState;
   if(newState==QNetworkSession::Connected)
        emit reconnectRequired();
}


