#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QtGui/QDialog>
#include <QDesktopWidget>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QDebug>
#include <QSettings>
#include "global_defs.h"
#include <qspotify_src/spotifysession.h>


class LoginDialog : public QDialog
{
    Q_OBJECT

public:
    LoginDialog(Spotify::Session* pSession,QSettings* pSettings, QWidget *parent = 0);
    ~LoginDialog();

    void resetState();
    bool getSaveCredentials();

private:

    QGridLayout m_Layout; //main layout manager

    QLabel m_UserIDText;
    QLineEdit m_UserIDInput;
    QLabel m_PasswordText;
    QLineEdit m_PasswordInput;
    QCheckBox m_SaveCredentials; //checkbox to indicate whether the user login credentails should be stored (i.e., for auto-login)
    QPushButton m_LoginBtn;

    Spotify::Session* m_pSession; //session instance
    QSettings* m_pAppSettings; //pointer to app settings instance

private slots:

    void OnLogin();

signals:

    void doSpotifyLogin(const QString&, const QString&, bool); //request to login

};

#endif // LOGINDIALOG_H
