#include "search.h"
#include "link.h"
#include <QDebug>
#include <QUrl>

namespace Spotify
{

    Search::Search(sp_session* session, sp_search* search, QObject* parent ):
            TrackCollection( parent ),
            m_session(session),
            m_search( search )
    {
        load();
    }

    Search::~Search()
    {
        if( m_search )
            sp_search_release( m_search );
    }

    bool Search::load()
    {
        // Load search. libspotify guarantees all tracks are available so we only want to do this once:
        if( m_search && sp_search_is_loaded( m_search ) && !isLoaded() )
        {
            // Set meta data:
            const char* charData = sp_search_query( m_search );
            m_searchQuery = QString::fromUtf8( charData, strlen( charData ) );

            charData = sp_search_did_you_mean( m_search );
            m_sugguestions = QString::fromUtf8( charData, strlen( charData ) );

            // Add tracks:
            qDebug()<< "Num tracks:" << sp_search_num_tracks( m_search );
            for( int i = 0; i < sp_search_num_tracks( m_search ); ++i )
            {
                sp_track* sptrack = sp_search_track( m_search, i );
                m_tracks.append( new Spotify::Track(m_session, sptrack, false, this ) );
            }

            // Add artists:
            for( int i = 0; i < sp_search_num_artists( m_search ); ++i )
            {
                sp_artist* spartist = sp_search_artist( m_search, i );
                m_artists.append( new Spotify::Artist( spartist, false, this ) );
            }

            // Add albums:
            for( int i = 0; i < sp_search_num_albums( m_search ); ++i )
            {
                sp_album* spalbum = sp_search_album( m_search, i );
                m_albums.append( new Spotify::Album( spalbum, false, this ) );
            }
            m_isLoaded = true;
            emit loaded();
        }
        return m_isLoaded;
    }
} // namespace Spotify
