//HelpViewer.cpp: Implementation of the HelpViewer class (dynamic online help content based on QWebView / QtWebKit).

#include "HelpViewer.h"

HelpViewer::HelpViewer(QWidget *pParent)
    : QDialog(pParent)
{
    //constructor; allocate webview instance etc;

    setWindowTitle(tr("Online Help"));

    m_pWebView = new QWebView(pParent);

    //setup signal / slot connections
    connect(m_pWebView,SIGNAL(loadStarted()),SLOT(OnContentLoadStarted()));
    connect(m_pWebView,SIGNAL(loadFinished(bool)),SLOT(OnContentLoadFinished(bool)));

    m_MainLayout.addWidget(m_pWebView);

    setLayout(&m_MainLayout); //set dialog main layout
}

HelpViewer::~HelpViewer()
{
}

void HelpViewer::setContent(const QString& url)
{
    //Set the url to be initially displayed. Path url is assumed to be local (file) path in case it does not contain e.g., http://.

    if(m_pWebView)
    {
        if(url.contains("://"))
            m_pWebView->setUrl(QUrl(url));
        else
            m_pWebView->setUrl(QUrl::fromLocalFile(url));

        m_pWebView->show();
    }
}

 void HelpViewer::OnContentLoadStarted()
 {
     //notification that web page load has been initiated
#ifdef Q_WS_MAEMO_5
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator,true); //show progress indicator
#endif
 }

void HelpViewer::OnContentLoadFinished(bool ok)
{
    //Notification that web content has completetly loaded (ok param is true on success)

#ifdef Q_WS_MAEMO_5
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false); //hide progress indicator
#endif
}
