#include "logindialog.h"

LoginDialog::LoginDialog(Spotify::Session* pSession, QSettings* pSettings, QWidget *parent)
    : QDialog(parent)
{
    //construct login dialog UI
    m_pSession = pSession;
    m_pAppSettings = pSettings;
    //setup signal / slot connections
    connect(&m_LoginBtn,SIGNAL(clicked()),SLOT(OnLogin()));
    setWindowTitle(tr("QSpot - Login"));

    //set up UI elements
    m_UserIDText.setText(tr("UserID:"));
    m_UserIDInput.setInputMethodHints(Qt::ImhNoAutoUppercase); //no auto-uppercase mode
    m_PasswordText.setText(tr("Password:"));
    m_PasswordInput.setEchoMode(QLineEdit::Password);

    m_LoginBtn.setText(tr("Login"));

    m_Layout.addWidget(&m_UserIDText,0,0);
    m_Layout.addWidget(&m_UserIDInput,0,1);
    m_Layout.addWidget(&m_PasswordText,1,0);
    m_Layout.addWidget(&m_PasswordInput,1,1);
    m_Layout.addWidget(&m_SaveCredentials,2,1,1,1);
    m_Layout.addWidget(&m_LoginBtn,3,1);
    m_Layout.setRowStretch(2,1);
    m_Layout.setRowStretch(3,50);

    setLayout(&m_Layout);
}

LoginDialog::~LoginDialog()
{
}


void LoginDialog::OnLogin()
{
    //request to login to Spotify
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator,true); //display progress indicator
#endif
    m_LoginBtn.setDisabled(true);
    m_SaveCredentials.setDisabled(true);
    emit doSpotifyLogin(m_UserIDInput.text(),m_PasswordInput.text(),m_SaveCredentials.isChecked());
}


void LoginDialog::resetState()
{
        //reset state after e.g., login
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false); //hide progress indicator
#endif
        m_pAppSettings->setValue("QSpot/SaveCredentials",0);
        m_LoginBtn.setDisabled(false);
        m_SaveCredentials.setDisabled(false);
        m_SaveCredentials.setChecked(false);
        m_UserIDInput.setText("");
	m_UserIDInput.setCursorPosition(0);
        m_PasswordInput.setText("");
	m_PasswordInput.setCursorPosition(0);
	m_UserIDInput.setFocus();
}

bool LoginDialog::getSaveCredentials()
{
    return m_SaveCredentials.isChecked();
}

