//ConnectionManager.cpp: Implementation of the ConnectionManager class.

#include "ConnectionManager.h"

ConnectionManager::ConnectionManager(QObject *pParent)
    : QObject(pParent)
{
    //constructor; initialise current network configuration / session etc.
   m_currNetworkStatus=QSystemNetworkInfo::UndefinedStatus;
   m_pNetInfo = new QSystemNetworkInfo(this);
   m_pNetSess = NULL;
}

bool ConnectionManager::init()
{
    //Attempt to establish internet connection using default configuration. Return true on success; false on failure.
    bool canStartIAP = (m_netConfMan.capabilities() & QNetworkConfigurationManager::CanStartAndStopInterfaces);
    //Use default configuration (if available)
    QNetworkConfiguration cfg = m_netConfMan.defaultConfiguration();
    if (!cfg.isValid() || (!canStartIAP && cfg.state() != QNetworkConfiguration::Active))
    {
        //no default config / active connection available
        return false;
    }
    if(!m_pNetSess)
    {
        m_pNetSess = new QNetworkSession(cfg, this);
        m_pNetSess->open(); //request to open network session
        if(!m_pNetSess->waitForOpened(-1)) //blocking wait
        {
            return false; //failure
        }
        //set up signal / slot connections
        connect(m_pNetSess,SIGNAL(stateChanged(QNetworkSession::State)),SLOT(OnSessionStateChanged(QNetworkSession::State)));
        connect(m_pNetSess,SIGNAL(newConfigurationActivated()),SLOT(OnNewConfigActivated()));
        connect(m_pNetInfo,SIGNAL(networkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)),SLOT(OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)));
        connect(&m_netConfMan,SIGNAL(onlineStateChanged(bool)),SLOT(OnOnlineStateChanged(bool)));
    }
    return true; //successfully established network session
}

ConnectionManager::~ConnectionManager()
{
}

void ConnectionManager::OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode mode, QSystemNetworkInfo::NetworkStatus newStatus)
{
    qDebug() << "Mode: " << mode << ", status: " << newStatus;
    if(newStatus==QSystemNetworkInfo::Connected && m_currNetworkStatus==QSystemNetworkInfo::NoNetworkAvailable) //new network status is Connected; send reconnect req.
      emit reconnectRequired();
    m_currNetworkStatus=newStatus;
}

bool ConnectionManager::currOnlineState()
{
    //Return true if current state is online; otherwise returns false (offline)
    return m_netConfMan.isOnline();
}

void ConnectionManager::OnOnlineStateChanged(bool isOnline)
{
    //notification that current active network config's online state has changed.
    qDebug() << "IsOnline: " << isOnline;
    if(isOnline)
     emit reconnectRequired();
}

void ConnectionManager::OnNewConfigActivated()
{
    //new network config activated for current session
    qDebug() << "New config activated";
}

void ConnectionManager::OnSessionStateChanged(QNetworkSession::State newState)
{
//notification about session state change
    qDebug() << "Session state change: " << newState;
   if(newState==QNetworkSession::Connected)
        emit reconnectRequired();
}


