//MainWindow.h: Header file for main application window class.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QWidget>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>
#include <QtGui/QAction>
#include <QtGui/QGridLayout>
#include <QtGui/QListView>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QStandardItem>
#include <QtGui/QListWidget>
#include <QtGui/QListWidgetItem>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QKeyEvent>
#include <QtGui/QCloseEvent>
#include <QSettings>
#include <QMessageBox>
#include <QFont>
#include <QTimer>
#include <QTranslator>
#include <QtMaemo5/QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "logindialog.h"
#include "SettingsDialog.h"
#include "TrackView.h"
#include "AlbumView.h"
#include "QueueView.h"
#include "artistview.h"
#include "AboutDialog.h"
#include "SpectrumAnalyzer.h"
#include "customlabel.h"
#include "OssoWrapper.h"
#include "lastfmscrobbler.h"
#include "DBusWrapper.h"
#include "global_defs.h"


//defines

#define APP_VERSION "0.9.0-5" //application version string

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.qspot")

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:

    void keyPressEvent(QKeyEvent *evt);

private:

    QSettings* m_pAppSettings; //application settings instance

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QTranslator m_appTranslator;

    LoginDialog* m_pLoginDlg;

    SettingsDialog* m_pSettingsDlg;

    TrackView* m_pTrackView; //artist view instance

    AlbumView* m_pAlbumView; //album view instance

    QueueView* m_pQueueView; //playqueue (Now Playing) view instance

    ArtistView* m_pArtistView; //artist view instance

    Spotify::Session* m_pSession; //main Spotify session instance (handles communication with Spotify backend)

    OssoWrapper* m_pOssoWrapper; //wrapper instance for libosso

    DBusWrapper* m_pDBusWrapper; //wrapper instance for D-bus interface

    LastFMScrobbler* m_pLastFMScrobbler; //Last.fm scrobbling instance

    QPushButton m_SearchBtn;

    QLineEdit m_SearchInput;

    QStandardItemModel *m_pPlaylistModel;

    ListViewDelegate *m_pPlaylistDelegate;

    QListView* m_pPlaylistView;

    QListWidget m_PlaylistInfo;

    CustomLabel m_NowPlayingIcon;

    QFont m_NowPlayingFont;

    CustomLabel m_NowPlayingInfo;

    CustomLabel m_NowPlayingPositionInfo;

    QString m_strNowPlayingInfo;

    SpectrumAnalyzer* m_pSpectrum; //spectrum analyzer widget

    QList<Spotify::Playlist*> m_Playlists; //list holding pointers to playlist instances

    QList<Spotify::Track*> m_PlayQueue; //current playqueue

    qint32 m_currQueuePos; //current position in the play queue (position of track being played)

    bool m_playing; //TRUE if in playing mode

    bool m_update; //TRUE in case UI elements should be updated

    qint64 m_currPlaybackPos; //playback position for currently playing track

    AboutDialog m_AboutDlg; //App About dialog instance

    QTimer *m_pTimeoutTimer; //timer used for detecting timeouts (i.e., during playlist loading)

    bool m_AudioInit; //TRUE in case audio playback thread initialised

    quint32 m_currSysVolume; //current system volume (used for volume control using HW zoom keys when screen is in locked state)

    qint32 m_currOrientation; //current display orientation

    void logout(); //logout current user and display the login dialog

    void initAboutDialog(); //setup the application about dialog

    void setupInitialState(); //set up the app initial state (audio etc.)

    void setDisplayOrientation(qint32 orientation); //set the display orientation

    void setupUILang(); //setup the UI language



private slots:

     void OnShowLogin();
     void OnLoggedIn(Spotify::Error error);
     void OnPlaylistContainersReady(QList<Spotify::Playlist*> playlists);
     void OnPlaylistActivated(QModelIndex index);
     void OnLoginDialogRejected();
     void OnMainMenuAction(QAction* action);
     void OnPlayingState(bool state);
     void OnSetPlayQueue(const QList<Spotify::Track*>& queue, qint32 currQueuePos);
     void OnPlayQueuePosUpdated(qint32 pos);
     void OnNowPlaying();
     void OnSearch();
     void OnSearchComplete(Spotify::Search* search);
     void OnPlaybackPositionUpdated(qint64 pos);
     void OnPlaybackTokenLost();
     void OnSettingsSaved();
     void OnPlaylistLoadingTimeout();
     void OnDisplayFMTransmitterDialog();
     void OnShowAlbumView(Spotify::Album* pAlbum);
     void OnShowArtistView(Spotify::Artist* pArtist);
     void OnScrobblingStatus(bool status, const QString& error);
     void OnScrobbleUpdateNowPlaying(const QString& strTrackName, const QString& strArtistName, const QString& strAlbumName, const QString& strAlbumArtist); //update Last.fm now playing info
     void OnScrobbleTrack(); //scrobble current track to Last.fm (and send scrobbles in queue)
     void OnOrientationChanged(); //device orientation changed (e.g, screen rotate)
     void OnDisplayStateChanged(bool state); //display state changed notification (i.e., true=ON, false=OFF)
     void OnHWZoomKeyPressed(quint32 keycode); //notification that HW zoom key has been pressed

signals:

     void showLogin();

};

#endif // MAINWINDOW_H
