#include <QPainter>
#include "CustomSlider.h"

CustomSlider::CustomSlider(QWidget *parent, int width, int height)
	: QWidget(parent)
{
	m_width = width;
	m_height = height;

        m_strText = "";

        this->setFixedSize(m_width, m_height);
	m_bgcolor = QColor(0, 0, 0);
	m_p1color = QColor(150, 150, 150);
	m_p2color = QColor(150, 150, 255);
}

CustomSlider::~CustomSlider()
{

}

void CustomSlider::setSize(int width, int height)
{
    m_width = width;
    m_height = height;
    this->setFixedSize(m_width, m_height);
}

void CustomSlider::paintEvent(QPaintEvent *)
{
	QPainter painter(this);

	painter.setRenderHint(QPainter::Antialiasing);

	painter.setPen(Qt::NoPen);

        //painter.setBrush(m_p1color);
        painter.setBrush(m_bgcolor);
	painter.drawRect(QRect(0,0,m_width,m_height));

	painter.setBrush(m_bgcolor);
	painter.drawRect(QRect(1,1,m_width-2,m_height-2));

	painter.setBrush(m_p1color);
	painter.drawRect(QRect(2,2,m_pos1,m_height-4));

	painter.setBrush(m_p2color);
	painter.drawRect(QRect(2,2,m_pos2,m_height-4));

        if(m_strText!="")
        {
            painter.setPen(m_textColor);
            painter.drawText(QRect(0,0,m_width-5,m_height),Qt::AlignRight|Qt::AlignVCenter,m_strText);
        }
}

void CustomSlider::mousePressEvent(QMouseEvent *event)
 {
     if (event->button() == Qt::LeftButton) {
		emit positionChanged(event->x());
     }
 }

void CustomSlider::setPos1(int pos)
{
	m_pos1 = pos;
	update();
}

void CustomSlider::setPos2(int pos)
{
	m_pos2 = pos;
	update();
}

void CustomSlider::setBgColor(QColor color) 
{
	m_bgcolor=color;
	update();
}

void CustomSlider::setP1Color(QColor color) 
{
	m_p1color = color;
	update();
}

void CustomSlider::setP2Color(QColor color) 
{
	m_p2color = color;
	update();
}
void CustomSlider::setTextColor(QColor color)
{
    m_textColor = color;
    update();
}

void CustomSlider::setText(const QString& txt)
{
    m_strText = txt;
    update();
}
