//PickSelectorAction.h: Header file for the PickSelectorAction class (provides support for adding QMaemo5ValueButton with
//associated QMaemo5ListPickSelector to e.g., the menubar (or other QWidgetAction container)).

#ifndef PICKSELECTORACTION_H
#define PICKSELECTORACTION_H

#include <QWidget>
#include <QWidgetAction>
#include <QStringList>
#include <QStringListModel>
#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>

class PickSelectorAction : public QWidgetAction {

    Q_OBJECT

public:

    PickSelectorAction(QObject *parent = 0);

    QWidget * createWidget(QWidget *parent);

    void setText(const QString& txt);

    void populateListModel(const QStringList& list); //populate the list model

    void setCurrentSelection(int selection); //set the current value button selection

    int getCurrentSelection(); //return the current selection


private slots:

    void selectionChanged(const QString& selection);

private:

    int m_currSelection;

    QString m_strText;

    QStringList m_List;

    QStringListModel *m_pListModel;

signals:

    void selectionChanged(int); //signal emitted when value button selection has changed
};



#endif // PICKSELECTORACTION_H
