#ifndef CUSTOMSLIDER_H
#define CUSTOMSLIDER_H

#include <QWidget>
#include <QMouseEvent>

class CustomSlider : public QWidget
{
	Q_OBJECT

public:
	CustomSlider(QWidget *parent, int width, int height);
	~CustomSlider();

	void setPos1(int pos);
	void setPos2(int pos);
        int getPos1() {return m_pos1; }
        int getPos2() {return m_pos2; }
	void setBgColor(QColor color);
	void setP1Color(QColor color);
	void setP2Color(QColor color);
        void setTextColor(QColor color);
        void setText(const QString& txt);

protected:
	void paintEvent(QPaintEvent *event);
	void mousePressEvent(QMouseEvent *event);

private:
	QColor m_bgcolor;
	QColor m_p1color;
	QColor m_p2color;
        QColor m_textColor;
	int m_width;
	int m_height;
	int m_pos1;
	int m_pos2;
        QString m_strText;

signals:
    void positionChanged(int);
};

#endif // CUSTOMSLIDER_H
