//PickSelectorAction.cpp: Implementation of the PickSelectorAction class.

#include "PickSelectorAction.h"

PickSelectorAction::PickSelectorAction(QObject *parent)
    : QWidgetAction(parent)
{

    m_pListModel = new QStringListModel(this);
    m_currSelection = 0;
}

void PickSelectorAction::setText(const QString& txt)
{
    //set caption text for the value button
    m_strText = txt;
}

QWidget * PickSelectorAction::createWidget(QWidget *parent)
{
    QMaemo5ListPickSelector *selector = new QMaemo5ListPickSelector(parent);
    selector->setModel(m_pListModel);
    selector->setCurrentIndex(m_currSelection);

    QMaemo5ValueButton *valueButton = new QMaemo5ValueButton(parent);
    valueButton->setText(m_strText);
    valueButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered); // Maemo5 style guide wants the menu entries centered.
    valueButton->setPickSelector(selector);

    connect(selector, SIGNAL(selected(const QString &)), this, SLOT(selectionChanged(const QString &)));

    return valueButton;
}

void PickSelectorAction::populateListModel(const QStringList& list)
{
    //populate the underlying list model
     m_List = list;
     m_pListModel->setStringList(list);
}

void PickSelectorAction::selectionChanged(const QString& selection)
{
    m_currSelection = m_List.indexOf(selection);
    emit selectionChanged(m_currSelection);
}

int PickSelectorAction::getCurrentSelection()
{
    //return the current selection
    return m_currSelection;
}

void PickSelectorAction::setCurrentSelection(int selection)
{
    //set the current selection
    if(selection >= 0 && selection <= m_List.size()-1)
         m_currSelection = selection;
}

