//MainWindow.h: Header file for the track view class (default playlist / search result / album view).

#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <QtGui/QWidget>
#include <QMainWindow>
#include <QtGui/QVBoxLayout>
#include <QWidgetAction>
#include <QMenuBar>
#include <QStringList>
#include <QPoint>
#include <QListView>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QStandardItem>
#include <QPixmap>
#include <QIcon>
#include <QDebug>
#include <QKeyEvent>
#include <QMaemo5InformationBox>
#include "ListViewDelegate.h"
#include "PickSelectorAction.h"
#include "CListView.h"
#include <qspotify_src/spotifysession.h>


//possible sorting alternatives

#define ORIGINAL     0
#define MOST_POPULAR 1
#define TRACK_ASC    2
#define TRACK_DESC   3
#define ARTIST_ASC   4
#define ARTIST_DESC  5
#define ALBUM_ASC    6
#define ALBUM_DESC   7

#define  TRACKVIEW_ID 3

class TrackView : public QMainWindow
{
    Q_OBJECT

public:
    TrackView(Spotify::Session* pSession, QWidget *parent = 0);
    ~TrackView();

    void setPlaylist(Spotify::Playlist* pPlaylist); //set the playlist for which tracks should be displayed
    void setSearchResults(Spotify::Search* pSearch); //set the search results to be displayed

protected:

    void keyPressEvent(QKeyEvent *evt);

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QVBoxLayout m_Layout;

    Spotify::Session* m_pSession;

    Spotify::Playlist* m_pPlaylist;

    QList<Spotify::Track*> m_TrackList; //list of tracks returned by e.g., search and contained in playlist

    QStandardItemModel *m_pTrackListModel;

    ListViewDelegate *m_pTrackListDelegate;

    CListView* m_pTrackListView;

    QStringList m_PlaylistSortByList; //sorting alternatives for playlist mode

    QStringList m_SearchSortByList; //sorting alternatives for search view mode

    PickSelectorAction* m_pSortByAct;

    qint32 m_CallerID; //passed as identifer to Spotify session methods requiring caller ID

    Spotify::Track* getTrackFromModelIndex(QModelIndex index); //get track instance pointer from model index

    void addTrackListModelItem(Spotify::Track* track, int pos); //append track to the track list item model

    void addTracks(Spotify::Playlist* playlist); //add playlist tracks to main tableview

    void addTracks(const QList<Spotify::Track*>& trackList); //add tracks from specified tracklist to main tableview

    void setPlayQueue(); //set playqueue (i.e., add all tracks from selected track to last track in list to playqueue)

    void setupContextMenu(); //set up the listview context menu
    void setupMenubar(); //set up the view menubar


private slots:

    void OnTrackActivated(QModelIndex trackIndex);
    void OnSortingSelectionChanged(int currSelection);
    void OnMenubarAction(QAction* action);
    void OnViewAlbumAction();
    void OnPlayAlbumAction();
    void OnViewArtistAction();
    void OnAlbumBrowseReady(Spotify::AlbumBrowser* browser, qint32 callerID);

signals:

    void playQueueSet(const QList<Spotify::Track*>&); //signal emitted upon new playqueue set
    void showFMTransmitterDialog(); //signal emitted upon request to show the FM Transmitter control panel dialog (plugin)
    void showAlbumView(Spotify::Album*); //request to show the album view for the specified album
    void showArtistView(Spotify::Artist*); //request to show the artist view for the specified artist
};

#endif // TRACKVIEW_H
