//MainWindow.h: Header file for the track view class (default playlist / search result / album view).

#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <QtGui/QWidget>
#include <QMainWindow>
#include <QtGui/QVBoxLayout>
#include <QWidgetAction>
#include <QMenuBar>
#include <QStringList>
#include <QListView>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QStandardItem>
#include <QPixmap>
#include <QIcon>
#include <QDebug>
#include <QCloseEvent>
#include <QKeyEvent>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "ListViewDelegate.h"
#include "PickSelectorAction.h"
#include "CListView.h"
#include "QueueView.h"


//possible sorting alternatives

#define ORIGINAL     0
#define MOST_POPULAR 1
#define TRACK_ASC    2
#define TRACK_DESC   3
#define ARTIST_ASC   4
#define ARTIST_DESC  5
#define ALBUM_ASC    6
#define ALBUM_DESC   7

class TrackView : public QMainWindow
{
    Q_OBJECT

public:
    TrackView(Spotify::Session* pSession, QWidget *parent = 0);
    ~TrackView();

    void setPlaylist(Spotify::Playlist* pPlaylist); //set the playlist for which tracks should be displayed
    void setSearchResults(Spotify::Search* pSearch); //set the search results to be displayed

    void setShuffleActive(bool active); //set whether shuffle mode is active

    bool getQueueViewUpdateBufPos(); //returns the update buffer position status for the TrackView QueueView instance

protected:

    void closeEvent(QCloseEvent* evt);

    void keyPressEvent(QKeyEvent *evt);

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QVBoxLayout m_Layout;

    Spotify::Session* m_pSession;

    Spotify::Playlist* m_pPlaylist;

    QList<Spotify::Track*> m_TrackList; //list of tracks returned by e.g., search and contained in playlist

    QueueView *m_pQueueView;

    QStandardItemModel *m_pTrackListModel;

    ListViewDelegate *m_pTrackListDelegate;

    CListView* m_pTrackListView;

    QStringList m_PlaylistSortByList; //sorting alternatives for playlist mode

    QStringList m_SearchSortByList; //sorting alternatives for search view mode

    PickSelectorAction* m_pSortByAct;

    bool m_Shuffle; //TRUE if Shuffle mode currently active


    void addTrackListModelItem(Spotify::Track* track, int pos); //append track to the track list item model

    void addTracks(Spotify::Playlist* playlist); //add playlist tracks to main tableview

    void addTracks(const QList<Spotify::Track*>& trackList); //add tracks from specified tracklist to main tableview

    void setPlayQueue(); //set playqueue (i.e., add all tracks from selected track to last track in list to playqueue)


private slots:

    void OnTrackActivated(QModelIndex trackIndex);
    void OnPlayQueuePosUpdated(qint32 pos,qint32 shufflePos);
    void OnSortingSelectionChanged(int currSelection);

signals:

    void playQueueSet(QList<Spotify::Track*>); //signal emitted upon playqueue set
    void playQueuePosUpdated(qint32,qint32); //signal emitted when position in playqueue has been updated
    void activeQueueViewChanged(bool,bool); //signal emitted when active queueview changed (first param is TRUE in case TrackView instance is active)
                                            //Second param indicates whether shuffle mode is currently active
};

#endif // TRACKVIEW_H
