#ifndef LINK_H
#define LINK_H

#include <QString>
#include "spotifysession.h"

namespace Spotify
{
    class Link
    {
        public:
            enum Type { INVALID, TRACK, ALBUM, ARTIST, SEARCH, PLAYLIST };

            Link();
            Link( const QString& url );
            ~Link();

            QString toString() const;
            bool isValid() const { return type() != INVALID; }
            sp_link* getLink() { return m_link; }
            Spotify::Link::Type type() const;

            static Spotify::Link fromTrack( const Spotify::Track* track );
            static Spotify::Link fromPlaylist( const Spotify::Playlist* playlist );
            static Spotify::Link fromAlbum( const Spotify::Album* album );
            static Spotify::Link fromArtist( const Spotify::Artist* artist );

        private:
            sp_link* m_link;
            Spotify::Link::Type m_type;
            QString m_uri;
    };
} // namespace Spotify

#endif // LINK_H
