//ListViewDelegate.h: Header file for the ListViewDelegate class (responsible for custom drawing of list items)

#ifndef LISTVIEWDELEGATE_H
#define LISTVIEWDELEGATE_H

#include <QtGui>

class ListViewDelegate : public QStyledItemDelegate
{
    Q_OBJECT

public:

    ListViewDelegate(QWidget* parent = 0);
    virtual ~ListViewDelegate();

    enum datarole {headerRole = Qt::UserRole + 100, subHeaderLeftJustifyRole = Qt::UserRole+101, subHeaderRightJustifyRole = Qt::UserRole+102, iconRole = Qt::UserRole+103};

    void setHeaderFontPointSize(int size);
    void setSubHeaderFontPointSize(int size);

protected:

    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const;

    QSize sizeHint(const QStyleOptionViewItem &option,
                   const QModelIndex &index ) const;

private:

    int m_HeaderFontPointSize;
    int m_SubHeaderFontPointSize;

    };


#endif // LISTVIEWDELEGATE_H
