//ListViewDelegate.cpp: Implementation of the ListViewDelegate class.

#include "ListViewDelegate.h"

ListViewDelegate::ListViewDelegate(QWidget* parent)
    : QStyledItemDelegate(parent)
{
    m_HeaderFontPointSize = -1;
    m_SubHeaderFontPointSize = -1;
}

ListViewDelegate::~ListViewDelegate()
{
}

void ListViewDelegate::setHeaderFontPointSize(int size)
{
    m_HeaderFontPointSize = size;
}

void ListViewDelegate::setSubHeaderFontPointSize(int size)
{
    m_SubHeaderFontPointSize = size;
}

QSize ListViewDelegate::sizeHint(const QStyleOptionViewItem & option , const QModelIndex & index) const
{
    //handles size allocation of single item in the associated listview
    QIcon icon = qvariant_cast<QIcon>(index.data(iconRole));
    QSize iconsize = icon.actualSize(option.decorationSize);
    QFont font = QApplication::font();
    if(m_HeaderFontPointSize!=-1)
        font.setPointSize(m_HeaderFontPointSize);
    QFontMetrics fm(font);

    return(QSize(iconsize.width(),iconsize.height()+fm.height() + 8));
}

void ListViewDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,const QModelIndex &index) const
 {
    //overriden paint method (handles drawing of custom listview item)

    QStyledItemDelegate::paint(painter,option,index); //call base

    painter->save();

    QFont font = QApplication::font();
    QFont subFont = QApplication::font();
    font.setBold(true);
    subFont.setWeight(subFont.weight()-2);
    if(m_HeaderFontPointSize!=-1)
        font.setPointSize(m_HeaderFontPointSize);
    if(m_SubHeaderFontPointSize!=-1)
        subFont.setPointSize(m_SubHeaderFontPointSize);

    QFontMetrics fm(font);
    QFontMetrics fmSub(subFont);

    QIcon icon = qvariant_cast<QIcon>(index.data(iconRole));
    QString headerText = qvariant_cast<QString>(index.data(headerRole));
    QString subTextLeftJustify = qvariant_cast<QString>(index.data(subHeaderLeftJustifyRole));
    QString subTextRightJustify = qvariant_cast<QString>(index.data(subHeaderRightJustifyRole));

    QSize iconsize = icon.actualSize(option.decorationSize);

    QRect headerRect = option.rect;
    QRect subheaderRect = option.rect;
    QRect iconRect = subheaderRect;

    iconRect.setRight(iconsize.width()+30);
    iconRect.setTop(headerRect.top()); //iconRect + 5
    headerRect.setLeft(iconRect.right());
    subheaderRect.setLeft(iconRect.right());
    headerRect.setTop(headerRect.top()+15);
    headerRect.setBottom(headerRect.top()+fm.height());

    subheaderRect.setTop(headerRect.bottom()+2);

    painter->drawPixmap(QPoint(iconRect.left()+(iconsize.width()/2)-15,iconRect.top()+(iconsize.height()/2)-5),icon.pixmap(iconsize.width(),iconsize.height()));

    painter->setFont(font);
    //painter->drawText(headerRect,headerText);
     painter->drawText(headerRect.left()-10,headerRect.top()+20,headerText);

    painter->setFont(subFont);
    painter->drawText(subheaderRect.left()-10,subheaderRect.top()+17,subTextLeftJustify);
    int subTextRightJustifyLen = fmSub.width(subTextRightJustify); //get length of string in pixels
    painter->drawText(subheaderRect.right()-subTextRightJustifyLen,subheaderRect.top()+17,subTextRightJustify);

    painter->restore();
 }

