//MainWindow.h: Header file for main application window class.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QWidget>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>
#include <QtGui/QAction>
#include <QtGui/QGridLayout>
#include <QtGui/QListWidget>
#include <QtGui/QListWidgetItem>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QCloseEvent>
#include <QSettings>
#include <QMessageBox>
#include <QFont>
#include <QtMaemo5/QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "logindialog.h"
#include "SettingsDialog.h"
#include "TrackView.h"
#include "QueueView.h"
#include "SpectrumAnalyzer.h"
#include "customlabel.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.qspot")

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:

    QSettings* m_pAppSettings; //application settings instance

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    LoginDialog* m_pLoginDlg;

    SettingsDialog* m_pSettingsDlg;

    TrackView* m_pTrackView;

    QueueView* m_pQueueView;

    Spotify::Session* m_pSession;

    QPushButton m_SearchBtn;

    QLineEdit m_SearchInput;

    QListWidget m_PlaylistInfo;

    CustomLabel m_NowPlayingIcon;

    QFont m_NowPlayingFont;

    CustomLabel m_NowPlayingInfo;

    CustomLabel m_NowPlayingPositionInfo;

    QString m_strNowPlayingInfo;

    SpectrumAnalyzer* m_pSpectrum; //spectrum analyzer widget

    QList<Spotify::Playlist*> m_Playlists; //list holding pointers to playlist instances

    QList<Spotify::Track*> m_PlayQueue; //current playqueue

    qint32 m_currQueuePos; //current playqueue position

    bool m_playing; //TRUE if in playing mode

    qint64 m_currPlaybackPos; //playback position for currently playing track

    qint64 m_currBuffPos; //buffering position for currently playing track

    void logout(); //logout current user and display the login dialog

    QMessageBox m_AboutDlg; //App About dialog instance


private slots:

     void OnShowLogin();
     void OnLoggedIn(Spotify::Error error);
     void OnPlaylistContainersReady(QList<Spotify::Playlist*> playlists);
     void OnPlaylistActivated(QListWidgetItem* item);
     void OnLoginDialogRejected();
     void OnMainMenuAction(QAction* action);
     void OnPlayingState(bool state);
     void OnSetPlayQueue(QList<Spotify::Track*> queue);
     void OnPlayQueuePosUpdated(qint32 pos);
     void OnNowPlaying();
     void OnSearch();
     void OnSearchComplete(Spotify::Search* search);
     void OnTrackPosUpdated(qint64 pos);
     void OnPlaybackPositionUpdated(qint64 pos);
     void OnPlaybackTokenLost();
     void OnActiveQueueViewChanged(bool active);
     void OnSettingsSaved();

signals:

     void showLogin();

};

#endif // MAINWINDOW_H
