#ifndef ARTISTCATALOGUE_H
#define ARTISTCATALOGUE_H
#include "trackcollection.h"
#include <QHash>

namespace Spotify
{
    class Artist;
    class Track;
    class Album;
    class ArtistCatalogue: public Spotify::TrackCollection
    {
        Q_OBJECT;

        public:
            ArtistCatalogue( sp_artistbrowse* ab, QObject* parent = 0 );

            sp_artistbrowse* getArtistBrowse() const { return m_artistbrowse; }
            Spotify::Artist* getArtist() { return m_artist; }
            QList< const byte* > getPortraits() const { return m_portraits; }
            QList< Spotify::Artist* > getSimilarArtists() { return m_similarArtists; }
            QString getBiography() const { return m_biography; }
            virtual bool load();
            virtual ~ArtistCatalogue();

            QHash< Spotify::Album*, QList< Spotify::Track* >* > getAlbums() const { return m_albums; }
            int getNumAlbums() const { return m_albums.count(); }

            QHash< Spotify::Album*, QList< Spotify::Track* >* > getSingles() const { return m_singles; }
            int getNumSingles() const { return m_singles.count(); }

            QHash< Spotify::Album*, QList< Spotify::Track* >* > getCompilations() const { return m_compilations; }
            int getNumCompilations() const { return m_compilations.count(); }

            QHash< Spotify::Album*, QList< Spotify::Track* >* > getOthers() const { return m_others; }
            int getNumOthers() const { return m_others.count(); }

        private:
            sp_artistbrowse* m_artistbrowse;
            Spotify::Artist* m_artist;
            QList< const byte* > m_portraits;
            QList< Spotify::Artist* > m_similarArtists;
            QString m_biography;

            QHash< Spotify::Album*, QList< Spotify::Track* >* > m_albums;
            QHash< Spotify::Album*, QList< Spotify::Track* >* > m_singles;
            QHash< Spotify::Album*, QList< Spotify::Track* >* > m_compilations;
            QHash< Spotify::Album*, QList< Spotify::Track* >* > m_others;

    };

} // namespace Spotify

#endif // ARTISTCATALOGUE_H
