//PlaybackThread.h: Thread class responsible for writing audio data using the PulseAudio interface

#ifndef PLAYBACKTHREAD_H
#define PLAYBACKTHREAD_H

#include <QThread>
#include <pulse/simple.h>

class PlaybackThread : public QThread
{
    Q_OBJECT

public:

    PlaybackThread(QObject* parent = 0);
    ~PlaybackThread();

    void stop(); //stop thread execution


private:

     void run(); //main thread loop implementation

     pa_simple* m_pAudioStream;

     bool m_exitThread; //set to true if thread execution should be stopped

signals:

     void playbackFinished(); //signal that playback of current track has finished
     void playing(bool); //signal emitted to indicate playing / paused state
     void resumeBuffering(); //signal emitted when FIFO falls below certain value (request to resume data buffering from Spotify)
     void playbackPositionUpdated(qint64); //signal emitted to indicate track progress / position (in secs). Parameter gives length (in secs) of currently added data buffer

};


#endif // PLAYBACKTHREAD_H
