//MainWindow.h: Header file for the track view class (default playlist / search result / album view).

#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <QtGui/QWidget>
#include <QMainWindow>
#include <QtGui/QVBoxLayout>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QStringList>
#include <QDebug>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "QueueView.h"


class TrackView : public QMainWindow
{
    Q_OBJECT

public:
    TrackView(Spotify::Session* pSession, QWidget *parent = 0);
    ~TrackView();

    void setPlaylist(Spotify::Playlist* pPlaylist); //set the playlist for which tracks should be displayed
    void setSearchResults(Spotify::Search* pSearch); //set the search results to be displayed

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QVBoxLayout m_Layout;

    Spotify::Session* m_pSession;

    Spotify::Playlist* m_pPlaylist;

    QList<Spotify::Track*> m_TrackList; //list of tracks returned by e.g., search

    QueueView *m_pQueueView;

    QTableWidget m_TrackInfo;

    void addTracks(Spotify::Playlist* playlist); //add playlist tracks to main tableview

    void addTracks(QList<Spotify::Track*> trackList); //add tracks from specified tracklist to main tableview

    void setPlayQueue(); //set playqueue (i.e., add all tracks from selected track to last track in list to playqueue)

private slots:

    void OnTrackActivated(QTableWidgetItem* trackItem);
    void OnPlayQueuePosUpdated(qint32 pos);

signals:

    void playQueueSet(QList<Spotify::Track*>); //signal emitted upon playqueue set
    void playQueuePosUpdated(qint32); //signal emitted when position in playqueue has been updated
};

#endif // TRACKVIEW_H
