#ifndef MAINWIN_H
#define MAINWIN_H

#include <QGraphicsView>
#include <QtDBus>
#include <QDebug>
#include <QtGui>
#include <QTextStream>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <QX11Info>
#include <QLabel>
#include <QApplication>
#include <QDesktopWidget>
#include <QCloseEvent>
#include <QGraphicsScene>
#include <QGraphicsProxyWidget>
#include <libintl.h>
#include <gconf/gconf-client.h>
#include <qcontactmanager.h>
#include <qcontact.h>
#include <qcontactphonenumber.h>
#include "mainview.h"
QTM_USE_NAMESPACE

class MainWin : public QGraphicsView
{
    Q_OBJECT
public:
    explicit MainWin(QWidget *parent = 0);
    ~MainWin();
    
private:
    QGraphicsScene *scene;
    QGraphicsProxyWidget *proxy;
    bool isPortrait;
    MainView *mainWidget;
    QLabel *label;
    QPointer<QContactManager> contactManager;
    bool isHildon;
    QList<QContact> contactsList;
    bool isLocked;
    bool hildon_lock;
    bool hildon_canRotate;
    bool rotation_changed;

signals:
    
public slots:
    void _show();
    void onIncommingCall(const QDBusObjectPath &path, const QString &number);
    void onCallStatusChanged(const uint &status);
    void onTerminatedCall();
    void onOrientationChanged();
    void acceptCall();
    void rejectCall();
    void setContactDetails(const QString &number);
    void onContactManagerChanged();
    void hideEvent(QHideEvent *);
    void onLockChanged(const QString &msg);
    void hildonLockRotation();
    void hildonRestoreRotation();
    void setDBus();
    void setXProperties();
};

#endif // MAINWIN_H
