#ifndef RADIO_H
#define RADIO_H

#include <QWidget>

class QLabel;
class QPushButton;
class QLCDNumber;
class QRadioTuner;
class QToolButton;
class ClickableImage;
class QComboBox;

QT_USE_NAMESPACE

class Radio : public QWidget
{
    Q_OBJECT
public:
     explicit Radio(QWidget *parent = 0);
    ~Radio();
    int currentFreq;
    int currentSet;
    int currentIndex;
    QStringList stationsList;
    QStringList set1List;
    QStringList set2List;
    QStringList set3List;
    QRadioTuner* radio;

private:
    QLabel* stationName;
    QLabel* signal;
    QLCDNumber *freq;
    ClickableImage *leftImage;
    ClickableImage *rightImage;
    QPushButton* searchLeft;
    QPushButton* searchRight;
    QPushButton* nextButton;

    QComboBox *stationsBox;

    void createUI();
    void saveSetLists();
    void loadSetLists();




signals:

public slots:
        void freqUp();
        void freqDown();
        void searchUp();
        void searchDown();
        void freqChanged(int f);
        void signalChanged(int s);
        void metaDataChanged();
        void stationPicked(QString);
        void populateBox();
        void setFreq(int);
        void saveCurrentFreq();
        void loadCurrentFreq();
        void nextButtonClicked();
        void setLastIndex();
        void restartRadio();


};

#endif // RADIO_H
