/*
 *  Copyright (C) 2010 Charles Clement <caratorn _at_ gmail.com>
 *
 *  This file is part of qquiz.
 *
 *  qquiz is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301  USA
 *
 */

#include <map>
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <QLabel>
#include <QtGui>
#include <QObject>
#include <QGridLayout>

#define APP_NAME			"qquiz"
#define APP_VERSION			0.1
#define AUTHOR				"Charles Clement <caratorn@gmail.com>"

#define SUBSET_PATTERN		"subset:"
#define CHAR_DELIM			';'
#define ANSWER_DELIM		'|'

#define DEFAULT_NR_COL		2

using namespace std;

class question {
	public:
		question();
		~question();
		question(QString s, QString r);
		QString hint;
		QString answer;
		QList<QString> alternate_answers;
		QLabel *label;
		int answered;
};

class quiz_file {
	public:
		QDir path;
		QString title;
		int id;
};

class quiz : public QObject{
	Q_OBJECT
	public:
		quiz();
		~quiz();
		void retrieve_quizzes();
		int read_quiz(const char *filename);
		void trim_questions();
		void build_index();
		void init_gui();
		void start_dialog();
		void display_score();
		void display_grid();
		void display_timer();
	public slots:
		void buzz(const QString& text);
		void update_timer();
		void choose_quiz();
		void end();
		void about();
	private:
		vector<question *> questions;
		vector<quiz_file *> files;
		quiz_file * current;
		QString title;
		QString description;
		int total;
		int subset;
		int correct;
		unsigned int total_time;
		unsigned int current_time;
		unsigned int max_label_length;
		map < QString, int > index;
		QWidget *window;
		QMenuBar *menu;
		QAction *give_up;
		QGridLayout *grid;
		QVBoxLayout *layout;
		QLineEdit *line;
		QScrollArea *scrollArea;
		QWidget *sub_window;
		QLabel *score;
		QLabel *timer_label;
		QTimer *timer;
};

