#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "contactslist.h"
#include "about.h"
#include <QMenuBar>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    setWindowTitle("Qontacts");

    iProgressDialog = new QProgressDialog(this);

    //Create actions
    aboutAction = new QAction(tr("About"), this);

    menuBar()->clear();
    menuBar()->addAction(aboutAction);

    connect(iProgressDialog, SIGNAL(canceled()), iProgressDialog, SLOT(hide()));
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(showAbout()));
    connect(ui->analyzeButton, SIGNAL(clicked()), this, SLOT(analyzeContacts()));

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::analyzeContacts()
{
    iProgressDialog->setModal(true);
    iProgressDialog->setWindowTitle("Qontacts");
    iProgressDialog->setLabelText("Analyzing Contacts...");
    iProgressDialog->setMaximum(0);
    iProgressDialog->setMinimum(0);
    iProgressDialog->setValue(0);
    iProgressDialog->setCancelButtonText(QString());
    iProgressDialog->show();
    iContactsList = new ContactsList(this);
#ifdef Q_WS_MAEMO_5
    iContactsList->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    iProgressDialog->hide();
    iContactsList->show();
}

void MainWindow::showAbout()
{
    About::showAbout(this);
}
