﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import time, re

class QonsoModel:
   def __init__(self):
      self.lastTime = ""
      self.voix = dict(int=0, str="0 min")
      self.voixMax = dict(int=0, str="0 min")
      self.data = ""
      self.dataMax = 0
      self.hforfait = ""
      self.facture = "Prochaine facture : "
      self.sms = ""
      self.report = dict(int=0, str="Pas de minutes report&eacute;es ce mois ci")
      self.regHM = "(\d+)*?\s*[Hh]?\s*(\d\d\d*)"

   def GetLastTime(self):
      return self.lastTime

   def GetForfait(self):
      return "Neo.3 illimite de 21h30 a 8h"

   def ExtractTime(self, s):
      res = re.search(self.regHM, s)
      timenum = 0
      timestr = "0 min"

      if res:
         h = 0
         if res.group(1):
            h = int(res.group(1))
         m = int(res.group(2))
         timenum = h*60+m
         h = int(timenum/60)
         m = timenum-h*60

         timestr = ""
         if h>=1:
            timestr = str(h)+"h"
         timestr = "%s%.2d min"%(timestr, m)
      
      return timenum, timestr
      
   def SetConsoVoix(self, s):
      self.voix['int'], self.voix['str'] = self.ExtractTime(s)
      
   def GetConsoVoix(self, type):
      return self.voix[type]

   def SetConsoVoixMax(self, s):
      self.voixMax['int'], self.voixMax['str'] = self.ExtractTime(s)

   def GetConsoVoixMax(self, type):
      return self.voixMax[type]

   def GetConsoData(self):
      if self.data:
         return self.data.simplified().replace("Mo", "").toFloat()[0]
      else:
         return 0

   def GetConsoDataMax(self):
      return self.dataMax

   def GetConsoSMS(self):
      return self.sms

   def GetConsoHorsForfait(self):
      return self.hforfait

   def GetDateProchaineFacture(self):
      return self.facture 
      
   def SetReport(self, s):
      self.report['int'], sreport = self.ExtractTime(s)

      if self.report['int'] == 0:
         self.report['str'] = "Pas de minutes report&eacute;es ce mois ci"
      else:
         self.report['str'] = "Report de minutes : "+sreport
      
   def GetReport(self, type):
      return self.report[type]
