#include "wstop.h"
#include "ui_wstop.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Wstop::Wstop(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Wstop)

{
    ui->setupUi(this);

    this->setWindowTitle(tr("Stoppers"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonKdoubleOH->setText(tr("Double Overhand Stopper"));
    ui->pushButtonKfig8->setText(tr("Figure 8 Knot"));
    ui->pushButtonKoyster->setText(tr("Oysterman's Stopper"));

    // For Connecting Keyboard Buttons
      connectSignals();

}

Wstop::~Wstop()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Wstop::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonKdoubleOH_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonKoyster_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonKfig8_pressed()));
}

// End of Keyboard Signals

//Buttons

void Wstop::on_pushButtonKdoubleOH_pressed()
{
    KdoubleOH *kdoubleOH = new KdoubleOH(this);
    kdoubleOH->exec();
}

void Wstop::on_pushButtonKoyster_pressed()
{
    Koyster *koyster = new Koyster(this);
    koyster->exec();
}

void Wstop::on_pushButtonKfig8_pressed()
{
    Kfig8 *kfig8 = new Kfig8(this);
    kfig8->exec();
}
