#include "kzeppelin.h"
#include "ui_kzeppelin.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Kzeppelin::Kzeppelin(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Kzeppelin)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Zeppelin Bend"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kzeppelin.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kzeppelin.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();


    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Zeppelin Bend</u></b> <br> \
        Form a loop near the end of each rope, hold one loop in each hand. <br> \
        The loop in your left hand should have the working end passing over the standing end, tail pointing away from you. <br> \
        The loop in your right hand should have the working end passing under the standing end, tail pointing toward you, <br> \
        <i>This is known as the 'b and q' or '69' method due to the shapes of the loops.</i> <br> \
        Place the loop in your left hand over the top of the other loop. <br> \
        Finally pass each tail end around there standing ends and through the loop, so they are pointing away from each other. <br> \
        Pull on the standing ends to tighten and dress the knot. <br> \
        <br> \
        <b>Important</b> <br> \
        Follow these steps carefully, this knot can be tied incorrectly forming an 'imposter knot' that looks similar but is far less secure. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();

}

Kzeppelin::~Kzeppelin()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Kzeppelin::connectSignals()
{

// Keyboard Shortcuts

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

//Push Buttons

void Kzeppelin::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Kzeppelin::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Kzeppelin::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
