#include "terms.h"
#include "ui_terms.h"

#include <QtCore/QCoreApplication>


Terminology::Terminology(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Terminology)


{
    ui->setupUi(this);

    setWindowTitle(tr("Knot Terminology"));

    ui->textBrowser->setText(tr
     ("\
     <b>Bend:</b> Joins two ropes together.<br> \
     <b>Bight:</b> Any curved section or U shape in the rope that doesn't cross. <br> \
     <b>Capsizing:</b> When a knot deforms under load, normally when knots are used or tied incorrectly. <br> \
     <b>Dressing: </b> Arranging a knot to improve its strength and reduce jamming. <br> \
     <b>Elbow:</b> Two crossing points created by an extra twist in a loop. <br> \
     <b>Half Knot:</b> Cross the ends of two ropes over each other, then pass one end over and then under. <br> \
     <b>Hitch:</b> Attaching a rope to an object, like a post; for example. <br> \
     <b>Jamming:</b> Any knot that is very difficult to untie after being loaded. <br> \
     <b>Loop:</b> A full circle formed by crossing the working end over itself. <br> \
     <b>Round Turn:</b> Two passes of the rope around an object to encircle it. <br> \
     <b>Spill:</b> see Capsizing <br> \
     <b>Standing End:</b> The end of rope not used in the knot, usually shown as unfinished. <br> \
     <b>Standing Part:</b> The section of rope between the standing end and the knot. <br> \
     <b>Stopper:</b> A knot tied and the end of a rope to prevent the rope passing through something. <br> \
     <b>Tail:</b> Another name for the end of the rope, used when a knot or bight is formed in the rope. <br> \
     <b>Turn:</b> Single pass of the rope around or through an object. <br> \
     <b>Working End:</b> The active end of the rope used to tie the knot. <br> \
     <b>Working Part:</b> The section of rope between the knot and the working end. \
     "));
}

Terminology::~Terminology()
{
      delete ui;
}
