#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

#include "selectwindows/wbend.h"
#include "selectwindows/wend.h"
#include "selectwindows/whitch.h"
#include "selectwindows/wmid.h"
#include "selectwindows/wstop.h"


class About;
class Help;
class Instructions;
class Terminology;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:


    // For Connecting Keyboard buttons
    void connectSignals();

    //Button Slots

    void on_pushButtonEnd_pressed();

    void on_pushButtonMid_pressed();

    void on_pushButtonBend_pressed();

    void on_pushButtonHitch_pressed();

    void on_pushButtonStop_pressed();

    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_actionTerms_triggered();

    void on_actionReadme_triggered();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    Instructions *instructions;
    Terminology *terms;

};

#endif // MAINWINDOW_H
