#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

class QNMSettings(QtCore.QSettings):
	def __init__(self, fileSetting, parent = None):
		QtCore.QSettings.__init__( self, fileSetting, QtCore.QSettings.IniFormat, parent  )

		self.groupMain = "main"
		self.key_language = "language"
		self.key_orientation = "orientation"

		self.groupMonitorOpt = "monitor"
		self.key_graphType = "graph_type"
		self.key_showRule = "show_ruler"
		self.key_showRX = "show_rx"
		self.key_showTX = "show_tx"
		self.key_timestamp = "timestamp"

		self.groupFilter = "filter"
		self.key_filterStartTime = "start_time"
		self.key_filterStopTime = "stop_time"
		self.key_filterStatus = "status_filter"
		self.key_filterIfcae = "interface"

		self.groupSessionOpt = "sessionview"
		self.key_showMarker_s = "show_ruler"
		self.key_showRX_s = "show_rx"
		self.key_showTX_s = "show_tx"
		self.key_timestamp_s = "timestamp"
		self.key_zoom_s = "zoom"
		self.key_graphType_s = "graph_type"

		self.groupNetStat = "netstat"
		self.key_autorefresh_ns = "autorefresh"

	#----------------------------------#
	def setTypeGraphStat( self ):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_graphType,"0")
		self.endGroup()
	
	def setTypeGraphTime( self ):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_graphType, "1")
		self.endGroup()

	def isTypeGrapStat(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "0" )
		self.endGroup()
		if val == "0":
			return True
		else:
			return False
	
	def isTypeGrapTime(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "1" )
		self.endGroup()
		if val == "1":
			return True
		else:
			return False
	
	def typeGraph(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "0" )
		self.endGroup()
		if val == "1":
			return 1
		else:
			return 0
	
	#----------------------------------#
	def showRuler(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showRule, "1")
		else:
			self.setValue(self.key_showRule, "0")
		self.endGroup()

	def isShowRuler(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showRule, "0" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showRX(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showRX, "1")
		else:
			self.setValue(self.key_showRX, "0")
		self.endGroup()

	def isShowRX(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showRX, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showTX(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showTX, "1")
		else:
			self.setValue(self.key_showTX, "0")
		self.endGroup()

	def isShowTX(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showTX, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def setTimestamp(self, seconds):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_timestamp, seconds)
		self.endGroup()

	def timestamp(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_timestamp, "30" )
		self.endGroup()
		val = val.toInt()
		return val[0]

	#===============================================================#
	def filterSetStartTime( self, startTime ):
		self.beginGroup( self.groupFilter )
		self.setValue(self.key_filterStartTime, startTime)
		self.endGroup()

	def filterGetStartTime(self):
		self.beginGroup( self.groupFilter )
		val = self.value( self.key_filterStartTime, None )
		self.endGroup()
		val = "%s"%val.toString()
		if val == "":
			val = None
		return val

	def filterRemStartTime(self):
		self.beginGroup( self.groupFilter )
		self.remove( self.key_filterStartTime )
		self.endGroup()
	
	#----------------------------------#
	def filterSetStopTime( self, stopTime ):
		self.beginGroup( self.groupFilter )
		self.setValue(self.key_filterStopTime, stopTime)
		self.endGroup()

	def filterGetStopTime(self):
		self.beginGroup( self.groupFilter )
		val = self.value( self.key_filterStopTime, None )
		self.endGroup()
		val = "%s"%val.toString()
		if val == "":
			val = None
		return val
	
	def filterRemStopTime(self):
		self.beginGroup( self.groupFilter )
		self.remove( self.key_filterStopTime )
		self.endGroup()

	#----------------------------------#
	def filterSetStatus( self, status_f ):
		self.beginGroup( self.groupFilter )
		self.setValue(self.key_filterStatus, status_f)
		self.endGroup()

	def filterGetStatus(self):
		self.beginGroup( self.groupFilter )
		val = self.value( self.key_filterStatus, "0" )
		self.endGroup()
		val = val.toInt()
		return val[0]
	
	#----------------------------------#
	def filterSetIfaceType( self, ifaceType ):
		self.beginGroup( self.groupFilter )
		self.setValue(self.key_filterIfcae, ifaceType)
		self.endGroup()

	def filterGetIfaceType(self):
		self.beginGroup( self.groupFilter )
		val = self.value( self.key_filterIfcae, 0 )
		self.endGroup()
		val = val.toInt()
		return val[0]
	
	def filterRemIfaceType(self):
		self.beginGroup( self.groupFilter )
		self.remove( self.key_filterIfcae )
		self.endGroup()
	
	
	#===============================================================#
	def showMarkerSession(self, show):
		self.beginGroup( self.groupSessionOpt )
		if show:
			self.setValue(self.key_showMarker_s, "1")
		else:
			self.setValue(self.key_showMarker_s, "0")
		self.endGroup()

	def isShowMarkerSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_showMarker_s, "0" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showRXSession(self, show):
		self.beginGroup( self.groupSessionOpt )
		if show:
			self.setValue(self.key_showRX_s, "1")
		else:
			self.setValue(self.key_showRX_s, "0")
		self.endGroup()

	def isShowRXSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_showRX_s, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showTXSession(self, show):
		self.beginGroup( self.groupSessionOpt )
		if show:
			self.setValue(self.key_showTX_s, "1")
		else:
			self.setValue(self.key_showTX_s, "0")
		self.endGroup()

	def isShowTXSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_showTX_s, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def setTimestampSession(self, minuts):
		self.beginGroup( self.groupSessionOpt )
		self.setValue(self.key_timestamp_s, minuts)
		self.endGroup()

	def timestampSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_timestamp_s, "2" )
		self.endGroup()
		val = val.toInt()
		return val[0]
	
	#----------------------------------#
	def setZoomSession(self, value):
		self.beginGroup( self.groupSessionOpt )
		self.setValue(self.key_zoom_s, value)
		self.endGroup()

	def zoomSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_zoom_s, "2" )
		self.endGroup()
		val = val.toInt()
		return val[0]
	
	
	#===============================================================#
	def setRefreshInterval_ns(self, seconds):
		self.beginGroup( self.groupNetStat )
		self.setValue(self.key_autorefresh_ns, seconds)
		self.endGroup()

	def refreshInterval_ns(self):
		self.beginGroup( self.groupNetStat )
		val = self.value( self.key_autorefresh_ns, "30" )
		self.endGroup()
		val = val.toInt()
		return val[0]


	#----------------------------------#
	def setTypeGraphStatSession( self ):
		self.beginGroup( self.groupSessionOpt )
		self.setValue(self.key_graphType_s,"0")
		self.endGroup()
	
	def setTypeGraphTimeSession( self ):
		self.beginGroup( self.groupSessionOpt )
		self.setValue(self.key_graphType_s, "1")
		self.endGroup()

	def isTypeGrapStatSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_graphType_s, "0" )
		self.endGroup()
		if val == "0":
			return True
		else:
			return False
	
	def isTypeGrapTimeSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_graphType_s, "1" )
		self.endGroup()
		if val == "1":
			return True
		else:
			return False
	
	def typeGraphSession(self):
		self.beginGroup( self.groupSessionOpt )
		val = self.value( self.key_graphType_s, "0" )
		self.endGroup()
		if val == "1":
			return 1
		else:
			return 0
	#----------------------------------#
	
	
	#===============================================================#
	def setLanguage(self, lang):
		self.beginGroup( self.groupMain )
		self.setValue(self.key_language, lang)
		self.endGroup()

	def language(self):
		self.beginGroup( self.groupMain )
		val = self.value( self.key_language, "0" )
		self.endGroup()
		val = val.toString()
		return val
	
	def setOrientation(self, orient):
		self.beginGroup( self.groupMain )
		self.setValue(self.key_orientation, orient)
		self.endGroup()

	def orientation(self):
		self.beginGroup( self.groupMain )
		val = self.value( self.key_orientation, "L" )
		self.endGroup()
		val = val.toString()
		return val
