#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
import OptionsWindow
from sys import path
import myconfig
from mydb import MyDB
from DialogOptionsIfaceExt import DialogOptionsIfaceExt
from MyNotify import MyNotify
from StatistData import checkOrientation

class OptionsWindowExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydb, mydbus, qset ):
		QtGui.QMainWindow.__init__(self, parent)
		
		self.mydbus = mydbus
		self.qset = qset
		self.parent = parent

		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			#self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "OptionsWindowExt::__init__(): Exception setAttribute(): ", e
		
		self.db = mydb

		self.ui = OptionsWindow.Ui_MainWindow()
		self.ui.setupUi( self )

		self.noti = MyNotify()

		self.listFreqTraffDaemon = list()
		self.listFreqTraffDaemon.append(10)
		self.listFreqTraffDaemon.append(15)
		self.listFreqTraffDaemon.append(20)
		self.listFreqTraffDaemon.append(30)
		self.listFreqTraffDaemon.append(40)
		self.listFreqTraffDaemon.append(60)

		self.listFormatDT = list()
		self.listFormatDT.append('yyyy-MM-dd HH:mm:ss')
		self.listFormatDT.append('MM-dd-yyyy HH:mm:ss')
		self.listFormatDT.append('dd-MM-yyyy HH:mm:ss')
		self.listFormatDT.append('dd.MM.yyyy HH:mm:ss')
		self.listFormatDT.append('MM.dd.yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy.MM.dd HH:mm:ss')
		self.listFormatDT.append('dd/MM/yyyy HH:mm:ss')
		self.listFormatDT.append('MM/dd/yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy/mm/dd HH:mm:ss')

		self.listLimitSizeDB = list()
		self.listLimitSizeDB.append(1209600)   #2 weeks
		self.listLimitSizeDB.append(2592000)   #1 month
		self.listLimitSizeDB.append(5184000)   #2 month
		self.listLimitSizeDB.append(7776000)   #3 month
		self.listLimitSizeDB.append(10368000)  #4 month
		self.listLimitSizeDB.append(12960000)  #5
		self.listLimitSizeDB.append(15552000)  #6
		self.listLimitSizeDB.append(23328000)  #9
		self.listLimitSizeDB.append(31104000)  #12
		self.listLimitSizeDB.append(0)         #not limit

		self.listLangauge = list()
		self.listLangauge.append("Auto")       #0
		self.listLangauge.append("English")    #1
		self.listLangauge.append("Russian")    #2
		self.listLangauge.append("Hungarian")  #3

		self.actionForm()

	def actionForm(self):
		self.ui.pb_ifaces.clicked.connect( self.dlgOptionsIfaces )

		#QComboBox cB_getData
		freq_traff_daemon = self.db.optGetFreqTraffDaemon()
		indx = self.listFreqTraffDaemon.index( int(freq_traff_daemon) )
		self.ui.cB_getData.setCurrentIndex( indx )
		#self.ui.cB_getData.currentIndexChanged.connect( self.changeFreqTraffDaemon )
		QtCore.QObject.connect(self.ui.cB_getData, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFreqTraffDaemon )

		#QComboBox cB_formatDT
		formatDT = self.db.optGetDateTimeFormat()
		indx = self.listFormatDT.index( formatDT )
		self.ui.cB_formatDT.setCurrentIndex( indx )
		#self.ui.cB_formatDT.currentIndexChanged.connect( self.changeFormatDT )
		QtCore.QObject.connect(self.ui.cB_formatDT, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFormatDT )

		#QComboBox cB_limitDB
		limitDB = self.db.optGetLimitSizeDB()
		indx = self.listLimitSizeDB.index( int(limitDB) )
		self.ui.cB_limitDB.setCurrentIndex( indx )
		#self.ui.cB_limitDB.currentIndexChanged.connect( self.changeLimitSizeDB )
		QtCore.QObject.connect(self.ui.cB_limitDB, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeLimitSizeDB )
		
		#кнопки цветов графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		r,g,b,a = self.colorRX.getRgb()
		self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		r,g,b,a = self.colorTX.getRgb()
		self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		
		self.ui.pb_colorRX.clicked.connect( self.changeColorRX )
		self.ui.pb_colorTX.clicked.connect( self.changeColorTX )

		self.ui.pB_orient_A.toggled.connect( self.orientation_auto )
		self.ui.pB_orient_L.toggled.connect( self.orientation_landscape )
		self.ui.pB_orient_P.toggled.connect( self.orientation_portrait )

		self.ui.cB_root.stateChanged.connect( self.rootAccessOnOff )
		self.rootAccessCheck()

		for i in self.listLangauge:
			self.ui.cB_language.addItem( i )
		self.ui.cB_language.currentIndexChanged.connect( self.changeLanguage )
		L = self.qset.language()
		if L == "0":
			self.ui.cB_language.setCurrentIndex( 0 )
		elif L == "en":
			self.ui.cB_language.setCurrentIndex( 1 )
		elif L == "ru":
			self.ui.cB_language.setCurrentIndex( 2 )
		elif L == "hu":
			self.ui.cB_language.setCurrentIndex( 3 )

		self_orientation = self.qset.orientation()
		if self_orientation == "L":
			self.ui.pB_orient_L.setChecked( True )
		elif self_orientation == "P":
			self.ui.pB_orient_P.setChecked( True )
		else:
			self.ui.pB_orient_A.setChecked( True )
		
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()


	def changeFreqTraffDaemon(self, indx_changed):
		sec = self.listFreqTraffDaemon[indx_changed]
		self.db.optSetFreqTraffDaemon( sec )
		self.mydbus.configUpdate()


	def changeFormatDT(self, indx_changed):
		frmt = self.listFormatDT[ indx_changed ]
		self.db.optSetDateTimeFormat( frmt )


	def changeLimitSizeDB(self, indx_changed):
		sec = self.listLimitSizeDB[ indx_changed ]
		self.db.optSetLimitSizeDB( sec )
		self.mydbus.limitDatabase( sec )


	def changeColorRX(self):
		cR = QtGui.QColorDialog.getColor( self.colorRX, self )
		if cR.isValid():
			self.colorRX = cR
			r,g,b,a = cR.getRgb()
			self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )


	def changeColorTX(self):
		cT = QtGui.QColorDialog.getColor( self.colorTX, self )
		if cT.isValid():
			self.colorTX = cT
			r,g,b,a = cT.getRgb()
			self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )
	

	
	def rootAccessOnOff(self, toggle):
		file = myconfig.qnetman_home + ".rootenabled"
		qf = QtCore.QFile( file )
		if toggle:
			qf.open( QtCore.QIODevice.WriteOnly )
			qf.close()
		else:
			qf.remove()

	def rootAccessCheck(self):
		file = myconfig.qnetman_home + ".rootenabled"
		if QtCore.QFile.exists( file ):
			self.ui.cB_root.setCheckState( QtCore.Qt.Checked )
			return True
		else:
			self.ui.cB_root.setCheckState( QtCore.Qt.Unchecked )
			return False

	#------------------------#
	def dlgOptionsIfaces(self):
		self.dlgOptIf = QtGui.QDialog( self )
		self.ui_optIf = DialogOptionsIfaceExt( self.dlgOptIf, self.db, self.mydbus )
		self.dlgOptIf.show()
		self.dlgOptIf.exec_()


	#------------------------#
	def changeLanguage( self, indx ):
		if indx == 0: #auto
			self.qset.setLanguage("0")
		elif indx == 1: #English
			self.qset.setLanguage("en")
		elif indx == 2: #Russian
			self.qset.setLanguage("ru")
		elif indx == 3: #Hungarian
			self.qset.setLanguage("hu")
		
		#txt = "Restart QNetMan to change the language GUI"
		#self.noti.notify( "%s"%txt )

	#===========================================#
	def orientation_auto( self ):
		try:
			self.parent.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, True )
			self.qset.setOrientation("A")
		except Exception, e:
			pass
	
	def orientation_portrait( self ):
		try:
			self.parent.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, False )
			self.parent.setAttribute( QtCore.Qt.WA_Maemo5PortraitOrientation, True )
			self.qset.setOrientation("P")
		except Exception, e:
			pass
		QtGui.QApplication.desktop().resized.emit(0)
	
	def orientation_landscape( self ):
		try:
			self.parent.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, False )
			self.parent.setAttribute( QtCore.Qt.WA_Maemo5LandscapeOrientation, True )
			self.qset.setOrientation("L")
		except Exception, e:
			pass
		QtGui.QApplication.desktop().resized.emit(0)
	#===========================================#
	def orientationChanged( self ):
		spacerItem = QtGui.QSpacerItem(7, 7, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
		spacerItem1 = QtGui.QSpacerItem(7, 7, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
			
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_getData )
		self.ui.gridLayout_2.removeWidget( self.ui.cB_getData )
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_limitDB )
		self.ui.gridLayout_2.removeWidget( self.ui.cB_limitDB )
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_formatDT )
		self.ui.gridLayout_2.removeWidget( self.ui.cB_formatDT )
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_ColorGraph )
		self.ui.gridLayout_2.removeItem( self.ui.horizontalLayout_colorButtons )
		self.ui.gridLayout_2.removeWidget( self.ui.pb_ifaces )
		self.ui.gridLayout_2.removeItem( spacerItem )
		self.ui.gridLayout_2.removeWidget( self.ui.cB_root )
		self.ui.gridLayout_2.removeItem( spacerItem1 )
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_Language )
		self.ui.gridLayout_2.removeWidget( self.ui.cB_language )
		self.ui.gridLayout_2.removeWidget( self.ui.lbl_Orient )
		self.ui.gridLayout_2.removeItem( self.ui.hL_orient )

		o = checkOrientation()
		if o == "L":
			# landscape
			self.ui.scrollArea.setMinimumSize(QtCore.QSize(790, 0))
			#self.ui.scrollAreaWidgetContents.setGeometry(QtCore.QRect(0, 0, 780, 560))
			self.ui.scrollAreaWidgetContents.setGeometry(QtCore.QRect(0, 0, 780, 720))

			self.ui.gridLayout_2.addWidget( self.ui.lbl_getData, 0, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_getData, 0, 1 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_limitDB, 1, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_limitDB, 1, 1 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_formatDT, 2, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_formatDT, 2, 1 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_ColorGraph, 3, 0 )
			self.ui.gridLayout_2.addItem( self.ui.horizontalLayout_colorButtons, 3, 1 )
			
			self.ui.gridLayout_2.addItem( spacerItem, 4, 0, 1, 2)
			self.ui.gridLayout_2.addWidget( self.ui.pb_ifaces, 5, 0, 1, 2 )
			self.ui.gridLayout_2.addItem( spacerItem, 6, 0, 1, 2)
			
			self.ui.gridLayout_2.addWidget( self.ui.cB_root, 7, 0, 1, 2 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_Language, 8, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_language, 8, 1 )
			
			self.ui.gridLayout_2.addWidget( self.ui.lbl_Orient, 9, 0, 1, 2 )
			self.ui.gridLayout_2.addItem( self.ui.hL_orient, 10, 0, 1, 2 )

		else:
			#portait
			self.ui.scrollArea.setMinimumSize(QtCore.QSize(430, 0))
			#self.ui.scrollAreaWidgetContents.setGeometry(QtCore.QRect(0, 0, 420, 830))
			self.ui.scrollAreaWidgetContents.setGeometry(QtCore.QRect(0, 0, 420, 1070))

			self.ui.gridLayout_2.addWidget( self.ui.lbl_getData, 0, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_getData, 1, 0 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_limitDB, 2, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_limitDB, 3, 0 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_formatDT, 4, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_formatDT, 5, 0 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_ColorGraph, 6, 0 )
			self.ui.gridLayout_2.addItem( self.ui.horizontalLayout_colorButtons, 7, 0 )
			
			self.ui.gridLayout_2.addItem( spacerItem, 8, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.pb_ifaces, 9, 0 )
			self.ui.gridLayout_2.addItem( spacerItem1, 10, 0 )
			
			self.ui.gridLayout_2.addWidget( self.ui.cB_root, 11, 0 )

			self.ui.gridLayout_2.addWidget( self.ui.lbl_Language, 12, 0 )
			self.ui.gridLayout_2.addWidget( self.ui.cB_language, 13, 0 )
			
			self.ui.gridLayout_2.addWidget( self.ui.lbl_Orient, 14, 0 )
			self.ui.gridLayout_2.addItem( self.ui.hL_orient, 15, 0 )

