# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from MainWindow import Ui_MainWindow
from ViewCurrentSessionExt import ViewCurrentSessionExt
from OptionsWindowExt import OptionsWindowExt
from ListSessionsExt import ListSessionsExt
from WinAboutExt import WinAboutExt
from WinNetStatProcExt import WinNetStatExt
from QNMDBusClient import QNMDBusClient
from StatistData import checkOrientation

import myconfig
import QNMSettings
from mydb import MyDB

class MainWindowExt( QtGui.QMainWindow ):
	#pvr# def __init__(self, splash, parent = None):
	def __init__(self, qset, parent = None):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			#self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "MainWindowExt::__init__(): Exception setAttribute():" , e

		self_orientation = qset.orientation()
		if self_orientation == "L":
			try:
				self.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, False )
				self.setAttribute( QtCore.Qt.WA_Maemo5LandscapeOrientation, True )
			except Exception, e:
				pass
		elif self_orientation == "P":
			try:
				self.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, False )
				self.setAttribute( QtCore.Qt.WA_Maemo5PortraitOrientation, True )
			except Exception, e:
				print "MainWindowExt::__init__(): Exception setAttribute():" , e
				pass
		else: #auto
			try:
				self.setAttribute( QtCore.Qt.WA_Maemo5AutoOrientation, True )
			except Exception, e:
				pass
		
		self.db = MyDB( myconfig.file_db )
		
		self.mydbus = QNMDBusClient()
		retVal = self.mydbus.connectDBus()
		if retVal == False:
			#splash.finish(self)
			#splash.finish(self)
			txt = QtGui.QApplication.translate("MainWindowExt", "Daemon QNetMan is not running.\nStart daemons now ?", None, QtGui.QApplication.UnicodeUTF8)
			txt_w = QtGui.QApplication.translate("MainWindowExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			r = QtGui.QMessageBox.question(self, txt_w, txt, QtGui.QMessageBox.Ok, QtGui.QMessageBox.Cancel)
			if r == QtGui.QMessageBox.Ok:
				res = self.daemonStart()
				if res:
					txt1 = QtGui.QApplication.translate("MainWindowExt", "Information", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("MainWindowExt", "Please restart the program now.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.information( self, txt1, txt2 )
				else:
					txt1 = QtGui.QApplication.translate("MainWindowExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("MainWindowExt", "Failed to start daemon.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.critical( self, txt1, txt2 )
			else:
				txt = QtGui.QApplication.translate("MainWindowExt", "Features will be limited.", None, QtGui.QApplication.UnicodeUTF8)
				QtGui.QMessageBox.information( self, txt_w, txt)

		self.ui = Ui_MainWindow()
		self.ui.setupUi( self )
		
		#настройки в конфигурационном файле
		#self.qset = QNMSettings.QNMSettings( myconfig.file_setting, self )
		self.qset = qset

		self.windowRealTime = ViewCurrentSessionExt( self, self.db, self.mydbus, self.qset )
		self.windowRealTime.hide()
		
		self.windowOptions = None

		self.windowAbout = WinAboutExt( self )
		self.windowAbout.hide()
		
		self.windowConnections = None
		self.windowConnections = WinNetStatExt( self, self.qset )
		self.flFirstRun = True

		self.windowListSessions = None
		self.windowListSessions = ListSessionsExt( self, self.db, self.qset )

		self.actionForm()

		#splash.finish(self)
		

	def actionForm(self):
		self.ui.pushButtonRealTime.clicked.connect( self.showRealTime )
		self.ui.pushButtonSession.clicked.connect( self.showListSessions )
		self.ui.pushButtonOption.clicked.connect( self.showOptions )
		self.ui.pushButtonConnections.clicked.connect( self.showConnections )
		QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL("triggered()"), self.windowAbout.show )

		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()

	
	def showRealTime(self):
		self.windowRealTime.show()

	def showListSessions(self):
		#if self.windowListSessions == None:
		#	self.windowListSessions = ListSessionsExt( self, self.db, self.qset )
		self.windowListSessions.show()
		self.windowListSessions.activateFilter()

	def showOptions(self):
		if self.windowOptions == None:
			self.windowOptions = OptionsWindowExt( self, self.db, self.mydbus, self.qset )
		self.windowOptions.show()

	def showConnections(self):
		#if self.windowConnections == None:
		if self.flFirstRun:
			#self.windowConnections = WinNetStatExt( self, self.qset )
			self.windowConnections.show()
			self.windowConnections.initData()
			self.flFirstRun = False
		else:
			self.windowConnections.show()
	

	def daemonStart(self):
		prg = "/opt/maemo/usr/bin/qnetmand"
		b = QtCore.QProcess.startDetached( prg )
		return b


	def orientationChanged( self ):
		self.ui.pushButtonConnections.hide()
		self.ui.pushButtonRealTime.hide()
		self.ui.pushButtonOption.hide()
		self.ui.pushButtonSession.hide()

		o = checkOrientation()
		if o == "L":
			#print "Landscape"
			self.ui.gridLayout.removeWidget( self.ui.pushButtonConnections )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonRealTime )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonOption )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonSession )

			self.ui.pushButtonConnections.setMinimumSize(QtCore.QSize(0, 190))
			self.ui.gridLayout.addWidget( self.ui.pushButtonConnections, 0, 0 )
        	
			self.ui.pushButtonRealTime.setMinimumSize(QtCore.QSize(0, 190))
			self.ui.gridLayout.addWidget( self.ui.pushButtonRealTime, 0, 1 )
			
			self.ui.pushButtonSession.setMinimumSize(QtCore.QSize(0, 190))
			self.ui.gridLayout.addWidget( self.ui.pushButtonSession, 1, 1 )
			
			self.ui.pushButtonOption.setMinimumSize(QtCore.QSize(0, 190))
			self.ui.gridLayout.addWidget( self.ui.pushButtonOption, 1, 0 )
		else:
			#print "Portrait"
			self.ui.gridLayout.removeWidget( self.ui.pushButtonConnections )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonRealTime )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonOption )
			self.ui.gridLayout.removeWidget( self.ui.pushButtonSession )

			self.ui.pushButtonConnections.setMinimumSize(QtCore.QSize(0, 180))
			self.ui.gridLayout.addWidget( self.ui.pushButtonConnections, 0, 0 )

			self.ui.pushButtonRealTime.setMinimumSize(QtCore.QSize(0, 180))
			self.ui.gridLayout.addWidget( self.ui.pushButtonRealTime, 1, 0 )
        	
			self.ui.pushButtonSession.setMinimumSize(QtCore.QSize(0, 180))
			self.ui.gridLayout.addWidget( self.ui.pushButtonSession, 2, 0 )
			
			self.ui.pushButtonOption.setMinimumSize(QtCore.QSize(0, 180))
			self.ui.gridLayout.addWidget( self.ui.pushButtonOption, 3, 0 )

		self.ui.pushButtonConnections.show()
		self.ui.pushButtonRealTime.show()
		self.ui.pushButtonOption.show()
		self.ui.pushButtonSession.show()

