# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from DialogComment import Ui_DialogComment


QtCore.Signal = QtCore.pyqtSignal
QtCore.Slot = QtCore.pyqtSlot


class DialogCommentExt(Ui_DialogComment, QtCore.QObject):
	commentAdd = QtCore.Signal()
	commentDel = QtCore.Signal()
	commentFailed = QtCore.Signal()
		
	new_comment = False

	def __init__(self, dlg, mydb, session_id ):
		QtCore.QObject.__init__(self)
		self.dlg = dlg
		self.setupUi(dlg)

		self.my_db = mydb
		self.session_id = session_id
		self.listSupportIface = self.my_db.optGetSupportIface()

		self.action()

	
	def action(self):
		self.pBSave.clicked.connect( self.saveComment )
		self.pBDelete.clicked.connect( self.deleteComment )


		self.pBSave.setEnabled( False )
		self.tEComment.textChanged.connect( self.textCommentChange )
		
		#get comment from db
		comment = self.my_db.getCommentSession( self.session_id )
		if comment != None:
			self.tEComment.setPlainText( comment )
			self.new_comment = False
			self.pBDelete.setEnabled( True )
		else:
			self.new_comment = True
			self.pBDelete.setEnabled( False )
		
		self.pBSave.setEnabled( False )
		
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()


	def textCommentChange( self ):
		num_symbols = len( self.tEComment.toPlainText() )
		if num_symbols == 0:
			self.pBSave.setEnabled( False )
		else:
			self.pBSave.setEnabled( True )
	

	def saveComment( self ):
		comment = self.tEComment.toPlainText()
		if comment != None:
			ok = self.my_db.setCommentSession( self.session_id, "%s"%comment, self.new_comment )
			if ok:
				self.commentAdd.emit()
			else:
				self.commentFailed.emit()

		self.dlg.hide()


	def deleteComment( self ):
		ok = self.my_db.delCommentSession( self.session_id )
		if ok:
			self.commentDel.emit()
		else:
			self.commentFailed.emit()
		self.dlg.hide()
	
	
	def orientationChanged( self ):
		screenGeometry = QtGui.QApplication.desktop().screenGeometry()
		
		self.gridLayout.removeWidget( self.lblComment )
		self.gridLayout.removeWidget( self.tEComment )
		self.gridLayout.removeWidget( self.pBDelete )
		self.gridLayout.removeWidget( self.pBSave )

		if screenGeometry.width() > screenGeometry.height():
			# landscape
			self.dlg.setMaximumSize(800, 205)
			self.dlg.setMinimumSize(800, 205)
			
			self.tEComment.setMinimumSize(600, 150)

			self.gridLayout.addWidget( self.lblComment, 0, 0, 1, 2 )
			self.gridLayout.addWidget( self.tEComment, 1, 0, 2, 1 )
			self.gridLayout.addWidget( self.pBDelete, 1, 1, 1, 1 )
			self.gridLayout.addWidget( self.pBSave, 2, 1, 1, 1 )
		else:
			#portait
			self.dlg.setMaximumSize(440, 330)
			self.dlg.setMinimumSize(440, 330)

			self.tEComment.setMinimumSize(430, 200)

			self.gridLayout.addWidget( self.lblComment, 0, 0, 1, 2 )
			self.gridLayout.addWidget( self.tEComment, 1, 0, 1, 2 )
			self.gridLayout.addWidget( self.pBDelete, 3, 0, 1, 1 )
			self.gridLayout.addWidget( self.pBSave, 3, 1, 1, 1 )
