# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

from DialogDBStatistics import Ui_DialogDBStat

class DialogDBStatisticsExt( Ui_DialogDBStat ):
	def __init__(self, parentDialog ):
		self.parentDialog = parentDialog
		Ui_DialogDBStat.__init__(self)
		self.setupUi( parentDialog )
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()

	def orientationChanged( self ):
		screenGeometry = QtGui.QApplication.desktop().screenGeometry()
			
		self.gridLayout.removeWidget( self.lblFileSizeTXT )
		self.gridLayout.removeWidget( self.lblFileSizeVal )
		self.gridLayout.removeWidget( self.lblTraffStatTXT )
		self.gridLayout.removeWidget( self.lblTraffStatVal )
		self.gridLayout.removeWidget( self.lblSesStatTXT )
		self.gridLayout.removeWidget( self.lblSesStatVal )
		self.gridLayout.removeWidget( self.lblFirstEntryTXT )
		self.gridLayout.removeWidget( self.lblFirstEntryVal )
		self.gridLayout.removeWidget( self.lblLastEntryTXT )
		self.gridLayout.removeWidget( self.lblLastEntryVal )

		if screenGeometry.width() > screenGeometry.height():
			# landscape
			self.parentDialog.setMaximumSize(800, 200)
			self.parentDialog.setMinimumSize(800, 200)#230

			self.gridLayout.addWidget( self.lblFileSizeTXT, 0, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblFileSizeVal, 0, 1, 1, 1 )
			
			self.gridLayout.addWidget( self.lblTraffStatTXT, 1, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblTraffStatVal, 1, 1, 1, 1 )
			
			self.gridLayout.addWidget( self.lblSesStatTXT, 2, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblSesStatVal, 2, 1, 1, 1 )
			
			self.gridLayout.addWidget( self.lblFirstEntryTXT, 3, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblFirstEntryVal, 3, 1, 1, 1 )
			
			self.gridLayout.addWidget( self.lblLastEntryTXT, 4, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblLastEntryVal, 4, 1, 1, 1 )
			
			self.gridLayout.addWidget( self.pB_Done, 3, 2, 2, 1 )
		else:
			# portait
			self.parentDialog.setMaximumSize(440, 500)#560
			self.parentDialog.setMinimumSize(440, 500)

			self.gridLayout.addWidget( self.lblFileSizeTXT, 0, 0 )
			self.gridLayout.addWidget( self.lblFileSizeVal, 1, 0 )
			
			self.gridLayout.addWidget( self.lblTraffStatTXT, 2, 0 )
			self.gridLayout.addWidget( self.lblTraffStatVal, 3, 0 )
			
			self.gridLayout.addWidget( self.lblSesStatTXT, 4, 0 )
			self.gridLayout.addWidget( self.lblSesStatVal, 5, 0 )
			
			self.gridLayout.addWidget( self.lblFirstEntryTXT, 6, 0 )
			self.gridLayout.addWidget( self.lblFirstEntryVal, 7, 0 )
			
			self.gridLayout.addWidget( self.lblLastEntryTXT, 8, 0 )
			self.gridLayout.addWidget( self.lblLastEntryVal, 9, 0 )
			
			self.gridLayout.addWidget( self.pB_Done, 10, 0 )
