# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from ViewSessionOptions import Ui_DialogSessionOptions


class ViewSessionOptionsExt( Ui_DialogSessionOptions ):
	def __init__( self, parentDialog ):
		self.parentDialog = parentDialog
		Ui_DialogSessionOptions.__init__(self)
		self.setupUi( parentDialog )
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()

	def orientationChanged( self ):
		screenGeometry = QtGui.QApplication.desktop().screenGeometry()
		
		self.gridLayout.removeWidget( self.cbRuler )
		self.gridLayout.removeWidget( self.lblTimestamp )
		self.gridLayout.removeWidget( self.sbTimestamp )
		self.gridLayout.removeItem( self.hL_typeGraph )
		self.gridLayout.removeItem( self.hL_viewTraff )

		if screenGeometry.width() > screenGeometry.height():
			# landscape
			self.parentDialog.setMaximumSize(800, 270)
			self.parentDialog.setMinimumSize(800, 270)

			self.gridLayout.addWidget( self.cbRuler, 0, 0, 1, 2 )
			self.gridLayout.addWidget( self.lblTimestamp, 1, 0, 1, 1 )
			self.gridLayout.addWidget( self.sbTimestamp, 1, 1, 1, 1 )
			self.gridLayout.addItem( self.hL_typeGraph, 2, 0, 1, 1 )
			self.gridLayout.addItem( self.hL_viewTraff, 2, 1, 1, 1 )
		else:
			#portait
			self.parentDialog.setMaximumSize(440, 410)
			self.parentDialog.setMinimumSize(440, 410)

			self.gridLayout.addWidget( self.cbRuler, 0, 0, 1, 1 )
			self.gridLayout.addWidget( self.lblTimestamp, 1, 0, 1, 1 )
			self.gridLayout.addWidget( self.sbTimestamp, 2, 0, 1, 1 )
			self.gridLayout.addItem( self.hL_typeGraph, 3, 0, 1, 1 )
			self.gridLayout.addItem( self.hL_viewTraff, 4, 0, 1, 1 )

