#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

import WinAbout
from SlidingStackedWidget import SlidingStackedWidget

from collections import deque
from os import popen
import myconfig
from mydb import MyDB

class WinAboutExt( QtGui.QMainWindow ):
	def __init__(self, parent ):
		QtGui.QMainWindow.__init__(self, parent)
				
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass

		self.ui = WinAbout.Ui_MainWindow()
		self.ui.setupUi( self )

		self.createSubSlidingWidgets()
		self.createSlidingStackedWidget()

		#XXX# Версия программы #XXX#
		self.ui.lblVersionVal.setText("0.7.7")

		self.actionForm()

	def actionForm(self):
		mainLayout = QtGui.QVBoxLayout()
		mainLayout.addWidget( self.slidingStacked )
		self.ui.wAbout.setLayout( mainLayout )

		self.ui.pBSplash.clicked.connect( self.openBrowser )
		self.ui.pb_nextA.clicked.connect( self.nextPage )
		self.ui.pb_prevA.clicked.connect( self.prevPage )
		self.ui.lblWwwVal.linkActivated.connect( self.openBrowser )
		
		self.numPage = 0
		self.ui.pb_prevA.setEnabled( False )

		self.setContentP1()
		self.setContentP2()
		self.setContentP3()
			
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_forward.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.ui.pb_nextA.setIcon(icon)
		self.ui.pb_nextA.setText("")
		
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_back.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.ui.pb_prevA.setIcon(icon)
		self.ui.pb_prevA.setText("")


	def openBrowser(self):
		cmd = 'dbus-send --system --type=method_call --dest=com.nokia.osso_browser /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"qnetman.garage.maemo.org"'
		b = popen( cmd )
		b.close()

	def createSlidingStackedWidget(self):
		self.slidingStacked = SlidingStackedWidget(self)
		self.slidingStacked.addWidget( self.slideWidget1 )
		self.slidingStacked.addWidget( self.slideWidget2 )
		self.slidingStacked.addWidget( self.slideWidget3 )
		animTime = 600
		self.slidingStacked.setSpeed( animTime )

		self.slidingStacked.myAnimationFinished.connect( self.animationFinished )
        
	def createSubSlidingWidgets(self):
		self.slideWidget1 = QtGui.QWidget( self )
		self.slideWidget2 = QtGui.QWidget( self )
		self.slideWidget3 = QtGui.QWidget( self )
            
		slideWidget1layout = QtGui.QVBoxLayout()
		self.slideWidget1.setLayout( slideWidget1layout )

		slideWidget2layout = QtGui.QVBoxLayout()
		self.slideWidget2.setLayout( slideWidget2layout )

		slideWidget3layout = QtGui.QVBoxLayout()
		self.slideWidget3.setLayout(slideWidget3layout)
            
		self.tE_p1 = QtGui.QTextEdit()
		self.tE_p1.setReadOnly( True )
		slideWidget1layout.addWidget( self.tE_p1 )
		
		self.tE_p2 = QtGui.QTextEdit()
		self.tE_p2.setReadOnly( True )
		slideWidget2layout.addWidget( self.tE_p2 )
		
		self.tE_p3 = QtGui.QTextEdit()
		self.tE_p3.setReadOnly( True )
		slideWidget3layout.addWidget( self.tE_p3 )
	

	def nextPage(self):
		self.slidingStacked.slideInNext()
		self.numPage += 1
		self.ui.pb_prevA.setEnabled( False )
		self.ui.pb_nextA.setEnabled( False )
		

	def prevPage(self):
		self.slidingStacked.slideInPrev()
		self.numPage -= 1
		self.ui.pb_prevA.setEnabled( False )
		self.ui.pb_nextA.setEnabled( False )
	

	def animationFinished( self ):
		if self.numPage == 0:
			self.ui.pb_prevA.setEnabled( False )
			self.ui.pb_nextA.setEnabled( True )
		elif self.numPage < 2:
			self.ui.pb_prevA.setEnabled( True )
			self.ui.pb_nextA.setEnabled( True )
		elif self.numPage == 2:
			self.ui.pb_nextA.setEnabled( False )
			self.ui.pb_prevA.setEnabled( True )


	def setContentP1(self):
		txt = QtGui.QApplication.translate("WinAboutExt", "Qt-based network manager which allows to monitor your network traffic. It is possible to record network sessions information for different connections and provide the information in graphical view.", None, QtGui.QApplication.UnicodeUTF8)
		str  = "<html>"
		str += "<div style='font-size: 18pt;'>"
		str += "<p><span style='color: blue;'>QNetMan</span> (QNetworkManager) - %s</p>"%txt
		str += "</div>"
		str += "</html>"
		self.tE_p1.setHtml( str )

	def setContentP2(self):
		txt1 = QtGui.QApplication.translate("WinAboutExt", "Thanks:", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("WinAboutExt", "Vladimir Sinichkin - for translation", None, QtGui.QApplication.UnicodeUTF8)
		txt3 = QtGui.QApplication.translate("WinAboutExt", "Used icon set \"Crystal-clear\" by Everaldo Coelho", None, QtGui.QApplication.UnicodeUTF8)
		txt4 = QtGui.QApplication.translate("WinAboutExt", "Krisztian Olah - for testing and good ideas", None, QtGui.QApplication.UnicodeUTF8)
		str  = "<html>"
		str += "<div style='font-size: 14pt;'>"
		str += "<p>%s</p>"%txt1
		str += "%s<br/>"%txt2
		str += "%s<br/>"%txt4
		str += "%s<br/>"%txt3
		str += "</div>"
		str += "</html>"
		self.tE_p2.setHtml( str )
	
	def setContentP3(self):
		txt1 = QtGui.QApplication.translate("WinAboutExt", "Licence:", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("WinAboutExt", "GPL v2", None, QtGui.QApplication.UnicodeUTF8)
		txt3 = QtGui.QApplication.translate("WinAboutExt", "Donate:", None, QtGui.QApplication.UnicodeUTF8)
		txt4 = QtGui.QApplication.translate("WinAboutExt", "You can donate to project via PayPal to qnetworkmanager@gmail.com", None, QtGui.QApplication.UnicodeUTF8)
		str  = "<html>"
		str += "<div style='font-size: 14pt;'>"
		str += "<p>%s</p>"%txt1
		str += "<p>%s</p>"%txt2
		str += "<p><a href='http://www.gnu.org/licenses/gpl.html'>http://www.gnu.org/licenses/gpl.html</a></p>"
		str += "<p>%s</p>"%txt3
		str += "<p>%s</p>"%txt4
		str += "</div>"
		str += "</html>"
		self.tE_p3.setHtml( str )
