#!/usr/bin/env python



class GetTraff:
	def __init__(self, iface, resetValue = False):
		self.rx0 = 0
		self.tx0 = 0
		self.iface = iface
		if resetValue == True:
			self.rx0, self.tx0 = self.getCurrBytesAbs()


	def getCurrBytesAbs(self):
		rx = 0
		tx = 0
		ok = False
		try:
			rx_fd = open('/sys/class/net/' + self.iface + '/statistics/rx_bytes', 'r')
			tx_fd = open('/sys/class/net/' + self.iface + '/statistics/tx_bytes', 'r')
			rx = int( rx_fd.read() )
			tx = int( tx_fd.read() )
			ok = True
		except:
			rx = 0
			tx = 0
		try:
			rx_fd.close()
			tx_fd.close()
		except:
			pass
		return (rx, tx, ok)

	def getCurrBytes(self):
		rx = 0
		tx = 0
		ok = False
		try:
			rx_fd = open('/sys/class/net/' + self.iface + '/statistics/rx_bytes', 'r')
			tx_fd = open('/sys/class/net/' + self.iface + '/statistics/tx_bytes', 'r')
			rx = int( rx_fd.read() ) - self.rx0
			tx = int( tx_fd.read() ) - self.tx0
			ok = True
		except:
			pass
		try:
			rx_fd.close()
			tx_fd.close()
		except:
			pass
		return (rx, tx, ok)

	def ifaceExist( self ):
		addr = 0
		try:
			addr_fd = open('/sys/class/net/' + self.iface + '/address', 'r')
			addr = addr_fd.read()
		except:
			pass
		try:
			addr_fd.close()
		except:
			pass
		return addr
