#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

import ViewSession
import StatistData

from collections import deque
from sys import path

#import myconfig
#from mydb import MyDB
from MyNotify import MyNotify

from MyGraphicsScene import MyGraphicsScene
import ViewSessionOptions
import DialogCommentExt

class ViewSessionExt( QtGui.QMainWindow ):
	def __init__(self, parent, db, qset, title, buffSessionTraff, session_id ):
		QtGui.QMainWindow.__init__(self, parent)
				
		#массив всех данных трафика за сессию
		self.buffSessionTraff = buffSessionTraff
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "ViewSessionExt::__init__(): Exception setAttribute(): ",e

		self.listLBL = list() #список с метками вертикальной оси

		self.ui = ViewSession.Ui_MainWindow()
		self.ui.setupUi( self )

		self.noti = MyNotify()
		#self.setWindowTitle( title )

		#геомертические параметры отображаемого графика
		self.lengthX = 770
		self.lengthY = 220
		self.shiftX = 0
		self.shiftY = 10
		
		#вспомогательные переменные
		#длина графика по оси Y
		self.Ly = self.lengthY-self.shiftY
		#длина графика по оси X
		self.Lx = self.lengthX-self.shiftX

		#self.X=0
		##self.scene = QtGui.QGraphicsScene()
		##XXX##
		self.scene = MyGraphicsScene( self )
		##XXX##
		self.scene.mousePressed.connect( self.sceneMousePress )
		self.ui.graphicsView.setScene(self.scene)
		self.ui.graphicsView.setSceneRect(0, 0, self.lengthX, self.lengthY)
		self.ui.graphicsView.centerOn(0,0)
		self.ui.graphicsView.setInteractive( True )
		self.ui.graphicsView.setDragMode( QtGui.QGraphicsView.ScrollHandDrag )
		
		#параметры для маркера
		self.itemLine = None
		self.itemBox = None
		self.itemText = None
		self.x_marker = 0
		self.y_marker = 0
		self.maxScaleY = 0
		self.showMarker = False

		self.pen_marker = QtGui.QPen( QtGui.QColor(170,170,170) )
		self.pen_marker.setWidth(1)
		self.pen_marker.setStyle( QtCore.Qt.DashDotLine )
	
		self.font_marker = QtGui.QFont()
		self.font_marker.setPointSize(9)
	
		self.bx_marker = QtGui.QPen( QtGui.QColor(110,110,110) )
		self.bx_marker.setWidth(15)
		self.bx_marker.setCapStyle( QtCore.Qt.RoundCap )
		
		#ширина линии графика (пиксель)
		self.pxLenGraph = 0

		#внешние установки
		self.db = db
		self.qset = qset
		self.session_id = session_id

		#цвета графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		self.ui.lblColorRX.setStyleSheet("background-color: %s;"%(rgbRX) )
		self.ui.lblColorTX.setStyleSheet("background-color: %s;"%(rgbTX) )

		self.maxZoom = 8 #максимальное значение zoom
		
		# *** инициализация настроек *** #
		#Отображаем ли линейку
		self.showMarker = self.qset.isShowMarkerSession()

		self.showRX = self.qset.isShowRXSession()
		self.showTX = self.qset.isShowTXSession()

		#масштабный коэф. по оси времени: во сколько раз ужимаем ось времени
		# 1px = 1sec / timeScale
		self.timeScale = self.qset.zoomSession()

		#временные отметки
		self.timestamp = self.qset.timestampSession()
		
		self.actionForm()

	def actionForm(self):
		self.ui.pBshowOptins.clicked.connect( self.dialogSessionOptions )

		self.ui.pBdialogComment.clicked.connect( self.dlgComment )
		
		self.ui.pBzoomIn.clicked.connect( self.zoomIn )
		self.ui.pBzoomOut.clicked.connect( self.zoomOut )
		if self.timeScale == 1:
			self.ui.pBzoomIn.setEnabled( False )
			self.ui.pBzoomOut.setEnabled( True )
		elif self.timeScale == self.maxZoom:
			self.ui.pBzoomIn.setEnabled( True )
			self.ui.pBzoomOut.setEnabled( False )
		else:
			self.ui.pBzoomIn.setEnabled( True )
			self.ui.pBzoomOut.setEnabled( True )
		
		self.ui.wWait.setWindowOpacity(0.45)
		self.ui.wWait.hide()

		self.listLBL.append( self.ui.lbl_v1 )
		self.listLBL.append( self.ui.lbl_v2 )
		self.listLBL.append( self.ui.lbl_v3 )
		self.listLBL.append( self.ui.lbl_v4 )
		self.listLBL.append( self.ui.lbl_v5 )

		#self.ui.graphicsView.setDragMode( QtGui.QGraphicsView.RubberBandDrag )
		self.ui.graphicsView.setDragMode( QtGui.QGraphicsView.ScrollHandDrag )
		#qaks = QtGui.QAbstractKineticScroller()
		
		self.dlgMO = QtGui.QDialog()
		self.ui_dlgMO = ViewSessionOptions.Ui_DialogSessionOptions( )
		self.ui_dlgMO.setupUi( self.dlgMO )

		self.ui_dlgMO.cbRuler.stateChanged.connect( self.changeViewMarker )
		self.ui_dlgMO.pbTraffRX.toggled.connect( self.changeShowRX )
		self.ui_dlgMO.pbTraffTX.toggled.connect( self.changeShowTX )
		self.ui_dlgMO.sbTimestamp.valueChanged.connect( self.changeTimestamp )


	def setTimeSession(self, allSeconds, hour, min, sec):
		self.allSec_t = allSeconds
		self.h_t = hour
		self.m_t = min
		self.s_t = sec

	def showData(self):
		#отображаем время сессии на форме
		len_buf_data = len( self.buffSessionTraff )
		
		strTgo = self.buffSessionTraff[0]["timestamp"]
		strTend = self.buffSessionTraff[len_buf_data-1]["timestamp"]
		
		if len_buf_data > 1:
			strFormatDateTime = self.db.optGetDateTimeFormat()
			
			txt_start = QtCore.QDateTime.fromString( self.buffSessionTraff[0]["timestamp"], "yyyy-MM-dd HH:mm:ss")
			txt_start = txt_start.toString( strFormatDateTime )
			
			txt_stop = QtCore.QDateTime.fromString( self.buffSessionTraff[len_buf_data-1]["timestamp"], "yyyy-MM-dd HH:mm:ss")
			txt_stop = txt_stop.toString( strFormatDateTime )

			self.ui.lblStartSessionValue.setText( txt_start )
			self.ui.lblEndSessionValue.setText( txt_stop )
		else:
			self.ui.lblStartSessionValue.setText( "YYYY-MM-DD HH:MM:SS" )
			self.ui.lblEndSessionValue.setText( "YYYY-MM-DD HH:MM:SS" )

		#txt_B = QtGui.QApplication.translate("ViewSessionExt", "B", None, QtGui.QApplication.UnicodeUTF8)
		#txt_kB = QtGui.QApplication.translate("ViewSessionExt", "kB", None, QtGui.QApplication.UnicodeUTF8)
		#txt_MB = QtGui.QApplication.translate("ViewSessionExt", "MB", None, QtGui.QApplication.UnicodeUTF8)

		#отображаем значения трафика за сессию
		#RXbytes = int( self.buffSessionTraff[len_buf_data-1]["rx"] )
		#TXbytes = int( self.buffSessionTraff[len_buf_data-1]["tx"] )
		(RXbytes,TXbytes) = StatistData.traffSession( self.buffSessionTraff )
		if RXbytes > 1048576:
			self.ui.lblInValue.setText( "%.2f MB"%(RXbytes/1048576.0) )
		elif RXbytes > 1024:
			self.ui.lblInValue.setText( "%.2f kB"%(RXbytes/1024.0) )
		else:
			self.ui.lblInValue.setText( "%s B"%(RXbytes) )
		
		if TXbytes > 1048576:
			self.ui.lblOutValue.setText( "%.2f MB"%(TXbytes/1048576.0) )
		elif TXbytes > 1024:
			self.ui.lblOutValue.setText( "%.2f kB"%(TXbytes/1024.0) )
		else:
			self.ui.lblOutValue.setText( "%s B"%(TXbytes) )
		
		#отображаем общее время сессии
		#( Hs, Ms, Ss ) = StatistData.sessionTime( strTgo, strTend )
		txt_h = QtGui.QApplication.translate("ViewSessionExt", "h", None, QtGui.QApplication.UnicodeUTF8)
		txt_m = QtGui.QApplication.translate("ViewSessionExt", "m", None, QtGui.QApplication.UnicodeUTF8)
		txt_s = QtGui.QApplication.translate("ViewSessionExt", "s", None, QtGui.QApplication.UnicodeUTF8)
		strTimeS = ""
		if self.h_t != 0:
			strTimeS += "%s %s "%(self.h_t, txt_h)
		if (self.m_t == 0 and self.h_t != 0) or (self.m_t != 0):
			strTimeS += "%02s %s "%(self.m_t, txt_m)
		strTimeS += "%02s %s"%(self.s_t, txt_s)
		self.ui.lblFullTimeHMS.setText( strTimeS )
		
		#отображаем общий трафик
		sumBytes = RXbytes + TXbytes
		if sumBytes > 1048576:
			self.ui.lblAllTraffValue.setText( "%.2f MB"%(sumBytes/1048576.0) )
		elif sumBytes > 1024:
			self.ui.lblAllTraffValue.setText( "%.2f kB"%(sumBytes/1024.0) )
		else:
			self.ui.lblAllTraffValue.setText( "%s B"%(sumBytes) )

		#рисуем график
		self.drawGraph()

		self.ui.menubar.setEnabled( False )
		self.ui.menubar.hide()

	def drawGrid(self, maxScaleY):
		pen = QtGui.QPen( QtGui.QColor(170,170,170) )
		pen.setWidth(1)
		pen.setStyle( QtCore.Qt.DotLine )

		font = QtGui.QFont()
		font.setPointSize(9)

		x = 0
		min = 0
		while x < self.Lx:
			self.scene.addLine( x+self.shiftX, 0, x+self.shiftX, self.lengthY - self.shiftY, pen )
			x += 60.0*self.timestamp/self.timeScale  # расстояние между вертикальными линиями сетки - 60 сек
			#min = (x/60.0)*self.timeScale
			min += self.timestamp
			#print "x=%s ---> %s"%(x,min)
			txt = self.scene.addText( "%s"%min, font )
			txt.setPos( self.shiftX + x -7 , self.lengthY - self.shiftY )
			
		
		partY = 4 #число рисуемых полос (градация) по Y
		stepLineY = self.Ly/(partY)
		currY = self.Ly
		it = 0
		myMaxScaleY = (maxScaleY/partY)*1.0
		while it < (partY+1):
			self.scene.addLine( self.shiftX, self.Ly-currY, self.Lx, self.Ly-currY, pen )
			txt = ""
			if( maxScaleY > 1024 ):
				txt = "%s kB/s"%( it*myMaxScaleY/1024.0 ) 
			else:
				txt = "%s B/s"%( it*myMaxScaleY ) 
			##self.scene.addText( txt, font ).setPos( self.shiftX+50, currY )##
			self.listLBL[ it ].setText( txt )
			#TODO: добавить сюда
			
			currY = currY - stepLineY
			it += 1

		#self.scene.update()
	
	def drawSystemCoord(self):
		pen = QtGui.QPen( QtGui.QColor(100,100,100) )
		pen.setWidth(4)

		self.scene.addLine(self.shiftX, self.lengthY-self.shiftY, self.Lx, self.lengthY-self.shiftY, pen) #X - time
		self.scene.addLine(self.shiftX, self.shiftX, self.shiftX, self.lengthY-self.shiftX, pen) #Y - Bytes

	def drawGraph(self):

		#рисуем текст "Rendering..." на графике
		#self.ui.lblWait.show()
		self.ui.wWait.show()

		self.calcTimeScale()

		self.scene.clear()
		
		#подготовка графических штучек
		penRX = QtGui.QPen( self.colorRX )
		penTX = QtGui.QPen( self.colorTX )
		
		penRX.setWidth( 1 )
		penTX.setWidth( 1 )
		
		brushRX = QtGui.QBrush(self.colorRX)
		brushTX = QtGui.QBrush(self.colorTX)

		#расчет графика
		bufRX = {}
		maxRX = 0
		bufTX = {}
		maxTX = 0
		bufDeltaT = {}
		j = 0
		len_buf_traff = len(self.buffSessionTraff) - 1
		#print "len_buf_traff=%s"%(len_buf_traff)
		while j < len_buf_traff:
			rx1 = int( self.buffSessionTraff[j+1]["rx"] )
			tx1 = int( self.buffSessionTraff[j+1]["tx"] )
			qdt_delta = StatistData.diffStrTime( self.buffSessionTraff[j]["timestamp"], self.buffSessionTraff[j+1]["timestamp"] )
			self.pxLenGraph = (1.0*qdt_delta)/self.timeScale #ширина линии графика
			if qdt_delta != 0:
				bufRX[j] = (rx1 - int( self.buffSessionTraff[j]["rx"] ))/qdt_delta #сердняя вх. скорость за промежуток времени qdt_delta
			else:
				bufRX[j] = 0
			#bufRX[j] = (rx1 - int( self.buffSessionTraff[j]["rx"] )) #средняя вх. скорость
			if bufRX[j] > maxRX:
				maxRX = bufRX[j]

			if qdt_delta != 0:
				bufTX[j] = (tx1 - int( self.buffSessionTraff[j]["tx"] ))/qdt_delta #сердняя исх. скорость за промежуток времени qdt_delta
			else:
				bufTX[j] = 0
			#bufTX[j] = (tx1 - int( self.buffSessionTraff[j]["tx"] )) #средняя исх. скорость
			if bufTX[j] > maxTX:
				maxTX = bufTX[j]
			bufDeltaT[j] = self.pxLenGraph
			j += 1

		
		# берем максимальное значение из каждой очереди если они рисуются обе,
		# иначе, макс. занчение графика, очередь которого будет отображаться
		maxRXTX = 0
		if self.showRX and self.showTX:
			maxRXTX = max(maxRX, maxTX)
		elif self.showRX and (self.showTX == False):
			maxRXTX = maxRX
		elif (self.showRX==False) and self.showTX:
			maxRXTX = maxTX
	
		#print "maxRX=%s; maxTX=%s; maxRXTX=%s"%(maxRX, maxTX, maxRXTX)
		# высчитываем масштабный коэффициент
		m = 1
		while True:
			if maxRXTX <= (2**m):
				break
			m += 1
		maxScaleY = 2**m
		#print "maxScaleY=%s"%maxScaleY
		self.maxScaleY = maxScaleY

		
		#!#dx = self.shiftX + self.pxLenGraph/2.0
		dx = self.shiftX + bufDeltaT[0]/2.0

		#отрисовка значений, входящего/исходящего трафика
		x=0
		j=0
		#XXX: очисттка экрана от надписей перед прорисовкой
		#self.scene.clear()
		len_buf_traff = len( bufDeltaT )
		while j < len_buf_traff:
			#*#penRX.setWidth( bufDeltaT[j] )
			#*#penTX.setWidth( bufDeltaT[j] )

			if self.showRX:
				r = (self.Ly*(1.0 / maxScaleY))*bufRX[j]
				#print "bufRX[%s]=%s;  r=%s"%(j,bufRX[j], r)
				if r != 0:
					#*#self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-r, penRX )
					rect = self.scene.addRect( x, self.Ly-r, bufDeltaT[j], r, penRX, brushRX )
					#rect.setOpacity(0.8)

			if self.showTX:
				t = (self.Ly*(1.0 / maxScaleY))*bufTX[j]
				#print "bufTX[%s]=%s;  t=%s"%(j,bufTX[j], t)
				if t != 0:
					#*#self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-t, penTX )
					rect = self.scene.addRect( x, self.Ly-t, bufDeltaT[j], t, penTX, brushTX )
					#rect.setOpacity(0.8)

			#print "%s --> x=%s (%s), r=%s t=%s"%(j,x,self.pxLenGraph, r, t)
			#!#x += self.pxLenGraph
			x += bufDeltaT[ j ]
			j += 1
		
		#отрисовка сетки и системы координат
		self.drawSystemCoord()
		self.drawGrid(maxScaleY)

		#линия - окончание сессии
		color = QtGui.QColor(255,0,0)
		pen = QtGui.QPen( color )
		pen.setWidth(2)
		self.scene.addLine( self.allSec_t/self.timeScale, self.Ly, self.allSec_t/self.timeScale, 0, pen)
		font = QtGui.QFont()
		font.setPointSize(7)
		txt = self.scene.addText( "End session", font )
		txt.setDefaultTextColor ( color )
		if (self.allSec_t/self.timeScale) > 100:
			txt.setPos( self.allSec_t/self.timeScale-70, self.Ly/4 )
		else:
			txt.setPos( self.allSec_t/self.timeScale, self.Ly/4 )

		#рисуем маркер
		self.drawMarkerScene()

		#убираем текст "Rendering..." и отображаем график
		self.scene.update()
		#self.ui.graphicsView.centerOn(x,0)
		#self.ui.lblWait.hide()
		self.ui.wWait.hide()

	def changeShowRX(self, state):
		self.showRX = state
		self.qset.showRXSession( state )
		self.drawGraph()

	def changeShowTX(self, state):
		self.showTX = state
		self.qset.showTXSession( state )
		self.drawGraph()


	def calcTimeScale(self):
		#длина сцены для графика
		if (self.allSec_t/self.timeScale) > (self.lengthX-self.shiftX):
			self.Lx = self.allSec_t/self.timeScale
		else:
			self.Lx = self.lengthX-self.shiftX
		
		deltaT_plus = 300/self.timeScale #добавили 600 - делаем сцену на 10 минут больше, для красной линии конца
		self.Lx += 300/self.timeScale
		
		self.ui.graphicsView.setSceneRect(0, 0, self.Lx, self.lengthY) 
		
		#минимальная толщина линии графика
		#min_pxLenGraph = 1/self.timeScale

		#кнопочки масштаба
		if self.timeScale == 1:
			self.ui.pBzoomOut.setEnabled( True )
			self.ui.pBzoomIn.setEnabled( False )
		elif self.timeScale > 1 and self.timeScale < self.maxZoom:
			self.ui.pBzoomOut.setEnabled( True )
			self.ui.pBzoomIn.setEnabled( True )
		elif self.timeScale == self.maxZoom:
			self.ui.pBzoomOut.setEnabled( False )
			self.ui.pBzoomIn.setEnabled( True )
		
		#print self.timeScale
		#if min_pxLenGraph < 1:
		#	self.timeScale = 1
		#else:
		#	self.timeScale = timeScale

		#print "timeScale=%s"%(self.timeScale)
		#return self.timeScale
		
	def zoomIn(self):
		if self.timeScale > 1:
			self.timeScale = self.timeScale/2
			self.drawGraph()
			self.qset.setZoomSession( self.timeScale )

	def zoomOut(self):
		self.timeScale = self.timeScale*2
		self.drawGraph()
		self.qset.setZoomSession( self.timeScale )

	#---------------- marker -----------------------#
	#вызывается, когда кликают на сцену
	def sceneMousePress(self, x, y):
		self.x_marker = x
		self.y_marker = y

		if self.itemLine != None:
			self.itemLine.hide()
			self.itemLine = None
		if self.itemBox != None:
			self.itemBox.hide()
			self.itemBox = None
		if self.itemText != None:
			self.itemText.hide()
			self.itemText = None
		self.drawMarkerScene()
	

	def drawMarkerScene(self):
		x = self.x_marker
		y = self.y_marker

		if self.showMarker:
			val = (self.maxScaleY - (1.0*y / self.Ly )*self.maxScaleY)
			if val < 0:
				val = 0
			if val > 1048576:
				val = "%.2f MB/s"%( val/1048576.0 )
			elif val > 1024:
				val = "%.2f kB/s"%(val/1024.0)
			else:
				val = "%.2f B/s"%(val)
			self.itemLine = self.scene.addLine( 0, y, self.Lx, y, self.pen_marker )
			dy = 10
			if y < 20:
				dy = -15
			self.itemBox = self.scene.addLine( x+15, y-dy, x+80, y-dy, self.bx_marker )
			self.itemText = self.scene.addText( "%s"%val, self.font_marker )
			self.itemText.setPos( x+15, (y-(dy+12)) )
		else:
			self.itemLine = None
			self.itemBox = None
			self.itemText = None
	
	#-----------------#
	def dialogSessionOptions(self):

		#включение линейки
		if self.qset.isShowMarkerSession():
			self.ui_dlgMO.cbRuler.setCheckState( QtCore.Qt.Checked )
			self.showMarker = True
			self.qset.showMarkerSession( True )
		else:
			self.ui_dlgMO.cbRuler.setCheckState( QtCore.Qt.Unchecked )
			self.showMarker = False
			self.qset.showMarkerSession( False )

		#Отображение графиков
		if self.showRX:
			self.ui_dlgMO.pbTraffRX.setChecked( True )
			self.qset.showRXSession( True )
		else:
			self.ui_dlgMO.pbTraffRX.setChecked( False )
			self.qset.showRXSession( False )
		
		if self.showTX:
			self.ui_dlgMO.pbTraffTX.setChecked( True )
			self.qset.showTXSession( True )
		else:
			self.ui_dlgMO.pbTraffTX.setChecked( False )
			self.qset.showTXSession( False )

		#Отображение значений временной метки
		self.ui_dlgMO.sbTimestamp.setValue( self.qset.timestampSession() )

		self.dlgMO.show()
		self.dlgMO.exec_()

	#изменение видимости линейки
	def changeViewMarker(self, state ):
		if state == QtCore.Qt.Checked:
			self.showMarker = True
			self.qset.showMarkerSession( True )
		else:
			self.showMarker = False
			self.qset.showMarkerSession( False )

	#изменения значений временных меток
	def changeTimestamp( self, value ):
		self.ui_dlgMO.sbTimestamp.setEnabled( False )
		self.qset.setTimestampSession( "%s"%value )
		self.timestamp = (int)(value)
		self.drawGraph()
		self.ui_dlgMO.sbTimestamp.setEnabled( True )
	
	
	#------- Dialog comment ----------#
	def dlgComment(self):
		self.dlgCom = QtGui.QDialog()
		self.ui_dlgCom = DialogCommentExt.DialogCommentExt( self.dlgCom, self.db, self.session_id )
		self.ui_dlgCom.commentAdd.connect( self.slotAddComment )
		self.ui_dlgCom.commentDel.connect( self.slotDelComment )
		self.ui_dlgCom.commentFailed.connect( self.slotFailComment )
		self.dlgCom.show()
		self.dlgCom.exec_()

	def slotAddComment( self ):
		txt = QtGui.QApplication.translate("ViewSessionExt", "Comment on the session is saved", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%txt )

	def slotDelComment( self ):
		txt = QtGui.QApplication.translate("ViewSessionExt", "Comment on the session is removed", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%txt )
	
	def slotFailComment( self ):
		txt = QtGui.QApplication.translate("ViewSessionExt", "Comment write error", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%txt )
