#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

from MyNotify import MyNotify
import ViewCurrentSession
import DialogRefreshInterval
import DialogNetworkIface
import DialogRecordDataExt
import MonitorOptions
import StatistData

from collections import deque

import dbus

#import QNMSettings

from gettraff import GetTraff
from mydb import MyDB
import myconfig

import sys

QtCore.Signal = QtCore.pyqtSignal
QtCore.Slot = QtCore.pyqtSlot

class MyGraphicsScene( QtGui.QGraphicsScene ):
	mousePressed = QtCore.Signal(int,int)
	def __init__(self, parent = None):
		QtGui.QGraphicsScene.__init__(self, parent)

	def mousePressEvent( self, eventGrSc ):
		p = eventGrSc.scenePos()
		self.mousePressed.emit( p.x(), p.y() )

		QtGui.QGraphicsScene.mousePressEvent( self, eventGrSc )

	


class ViewCurrentSessionExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydb, mydbus, qset, iface='gprs0'):
		QtGui.QMainWindow.__init__(self, parent)

		self.mydbus = mydbus
		self.db = mydb

		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "ViewCurrentSessionExt::__init__(): Exception setAttribute(): ",e

		self.qset = qset

		self.frm = ViewCurrentSession.Ui_ViewCurrentSession()
		self.frm.setupUi( self )
		self.actionForm()

		listSupportIface = self.db.optGetSupportIface()
		if len(listSupportIface) != 0:
			self.iface = listSupportIface[0]['iface']
		else:
			self.iface = iface
		
		self.setWindowTitle( self.iface )

		self.rx0 = 0
		self.rx1 = 0
		self.tx0 = 0
		self.tx1 = 0
		self.maxRX = 0
		self.maxTX = 0
		self.getTraffData( self.iface )

		#установки таймера, периодичности получения данных
		self.timeout = 2 #sec
		self.timer = QtCore.QTimer()
		QtCore.QObject.connect( self.timer, QtCore.SIGNAL("timeout()"), self.drawGraph )
		self.timer.start( self.timeout * 1000 )

		#таймер индикатора записи
		self.timeoutRecIndicator = 1 #sec
		self.timerRecIndicator = QtCore.QTimer()
		QtCore.QObject.connect( self.timerRecIndicator, QtCore.SIGNAL("timeout()"), self.actionRecIndicator )
		self.statusRecDBus = False
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface )
		except Exception:
			pass
		self.showRec = True
		self.frm.widgetRecordStatus.hide()

		#деки - очереди, содержащие данные, отображаемые на графике
		self.viewPointOnGraphRX = deque([])
		self.viewPointOnGraphTX = deque([])

		#геомертические параметры отображаемого графика
		self.lengthX = 770
		self.lengthY = 280
		self.shiftX = 0
		self.shiftY = 10
		
		#вспомогательные переменные
		#длина графика по оси Y
		self.Ly = self.lengthY-self.shiftY
		#длина графика по оси X
		self.Lx = self.lengthX-self.shiftX

		self.X=0
		self.scene = QtGui.QGraphicsScene()
		##XXX##self.scene = MyGraphicsScene( self )
		##XXX##self.scene.mousePressed.connect( self.sceneMousePress )

		self.frm.graphicsView.setScene(self.scene)
		self.frm.graphicsView.setSceneRect(0, 0, self.lengthX, self.lengthY)
		self.frm.graphicsView.centerOn(0,0)

		#параметры для маркера
		self.itemLine = None
		self.itemBox = None
		self.itemText = None
		self.x_marker = 0
		self.y_marker = 0
		self.maxScaleY = 0

		self.pen_marker = QtGui.QPen( QtGui.QColor(170,170,170) )
		self.pen_marker.setWidth(1)
		self.pen_marker.setStyle( QtCore.Qt.DashDotLine )
	
		self.font_marker = QtGui.QFont()
		self.font_marker.setPointSize(9)
	
		self.bx_marker = QtGui.QPen( QtGui.QColor(110,110,110) )
		self.bx_marker.setWidth(15)
		self.bx_marker.setCapStyle( QtCore.Qt.RoundCap )
			

		# *** инициализация настроек *** #
		#тип рисуемого графика
		# 0 - статичтический вид
		# 1 - временной вид
		self.typeGraph = self.qset.typeGraph()

		#Отображаем ли линейку
		self.showMarker = self.qset.isShowRuler()

		self.showRX = self.qset.isShowRX()
		self.showTX = self.qset.isShowTX()

		self.timestamp = self.qset.timestamp()

		# *** * *** #

		#ширина линии графика (пиксель)
		self.pxLenGraph = 5

		self.noti = MyNotify()

		self.dbusWaitDisplayOff()

		#инициаизация приемников dbus сигналов от демона ( запуск/остановка записи )
		self.session_bus = dbus.SessionBus( )
		self.session_bus.add_signal_receiver( self.dbusSignalReceiver_recStarted, dbus_interface=None, signal_name="recStarted", bus_name="com.qnetman.Daemon", path="/QNetManDBus")
		self.session_bus.add_signal_receiver( self.dbusSignalReceiver_recStoped, dbus_interface=None, signal_name="recStoped", bus_name="com.qnetman.Daemon", path="/QNetManDBus")
	

	#обработчкик dbus - сигналов запуска/остановки записи на сетевых интерфейсах
	def dbusSignalReceiver_recStarted(self, iface):
		self.statusRecDBus = self.mydbus.recStatus( self.iface ) #включена ли запись на сетевом интерфейсе
		#print "dbusSignalReceiver_recStarted(%s)"%iface

	def dbusSignalReceiver_recStoped(self, iface):
		self.statusRecDBus = self.mydbus.recStatus( self.iface ) #включена ли запись на сетевом интерфейсе
		#print "dbusSignalReceiver_recStoped(%s)"%iface

	
	def drawSystemCoord(self):
		pen = QtGui.QPen( QtGui.QColor(100,100,100) )
		pen.setWidth(4)

		delta = self.shiftX
		self.scene.addLine(delta, self.lengthY-self.shiftY, self.lengthX, self.lengthY-self.shiftY, pen) #X - time
		self.scene.addLine(delta, 0+delta, delta, self.lengthY-delta, pen) #Y - Bytes


	def drawGrid(self, maxScaleY):
		pen = QtGui.QPen( QtGui.QColor(170,170,170) )
		pen.setWidth(1)
		pen.setStyle( QtCore.Qt.DotLine )

		font = QtGui.QFont()
		font.setPointSize(9)

		x = 0
		ts = 0
		while x < self.lengthX:
			self.scene.addLine( x+self.shiftX, 0, x+self.shiftX, self.lengthY - self.shiftY, pen )
			x += (self.timestamp/self.timeout)*self.pxLenGraph # 1 расстояние между вертикальными линиями сетки - 30 сек
			ts += self.timestamp
			self.scene.addText( "%s"%ts, font ).setPos( x-10, self.lengthY-15 )
			
		
		partY = 4.0
		stepLineY = self.Ly/(partY) #шаг горизонтально (по оси Y) линии сетки
		currY = self.Ly
		it = 0
		myMaxScaleY = maxScaleY/partY
		while it < (partY+1):
			self.scene.addLine( self.shiftX, self.Ly-currY, self.lengthX, self.Ly-currY, pen )
			txt = ""
			if( maxScaleY > 1048576 ):
				txt = "%s MB/s"%( it*myMaxScaleY/1048576.0 ) 
			if( maxScaleY > 1024 ):
				txt = "%s kB/s"%( it*myMaxScaleY/1024.0 ) 
			else:
				txt = "%s B/s"%( it*myMaxScaleY ) 
			self.scene.addText( txt, font ).setPos( self.shiftX, currY )
			
			currY = currY - stepLineY
			it += 1



	def drawGraph(self):
		#цвета графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		self.frm.lblColorRX.setStyleSheet("background-color: %s;"%(rgbRX) )
		self.frm.lblColorTX.setStyleSheet("background-color: %s;"%(rgbTX) )
		#print >> sys.stderr, "style ok"

		dx = self.shiftX + self.pxLenGraph/2

		self.scene.clear()
		#print >> sys.stderr, "clear ok"

		#получаем результат - переводим его в скорость: байт/сек
		rx,tx,ok = self.getTraffData( self.iface )
		if ok:
			self.setWindowTitle( "%s - online"%self.iface )
			if ( (self.timerRecIndicator.isActive() == False) and (self.statusRecDBus) ):
				self.timerRecIndicator.start( self.timeoutRecIndicator*1000 )
			elif ( (self.timerRecIndicator.isActive()) and (self.statusRecDBus == False) ):
				self.timerRecIndicator.stop()
				self.frm.widgetRecordStatus.hide()
		else:
			self.setWindowTitle( "%s - offline"%self.iface )
			if self.timerRecIndicator.isActive() == True:
				self.timerRecIndicator.stop()
				self.frm.widgetRecordStatus.hide()
		rx = (rx*1.0)/self.timeout
		tx = (tx*1.0)/self.timeout 
		#print >> sys.stderr, "getTraffData ok"

		# проталкиваем очередное полученное значение в очередь
		if( (self.X+dx) > self.lengthX ):
			try:
				self.viewPointOnGraphRX.popleft()
			except:
				pass
			try:
				self.viewPointOnGraphTX.popleft()
			except:
				pass
			self.X = self.lengthX
		self.viewPointOnGraphRX.append( rx )
		self.viewPointOnGraphTX.append( tx )
		#print >> sys.stderr, "popleft ok"

		# берем максимальное значение из каждой очереди если они рисуются обе,
		# иначе, макс. занчение графика, очередь которого будет отображаться
		maxRXTX = 0
		if self.showRX and self.showTX:
			self.maxRX = max( self.viewPointOnGraphRX )
			self.maxTX = max( self.viewPointOnGraphTX )
			maxRXTX = max(self.maxRX, self.maxTX)
		elif self.showRX and (self.showTX == False):
			self.maxRX = max( self.viewPointOnGraphRX )
			maxRXTX = self.maxRX
		elif (self.showRX==False) and self.showTX:
			self.maxTX = max( self.viewPointOnGraphTX )
			maxRXTX = self.maxTX

		# высчитываем масштабный коэффициент
		m = 1
		while True:
			if maxRXTX <= (2**m):
				break
			m += 1
		maxScaleY = 2**m
		
		#отрисовка значений, заполняющих каждую деку входящего/исходящего трафика
		x=0
		j=0
		if self.typeGraph == 0:
			penRX = QtGui.QPen( self.colorRX )
			penRX.setWidth( self.pxLenGraph )
			penTX = QtGui.QPen( self.colorTX )
			penTX.setWidth( self.pxLenGraph )

			while j < len(self.viewPointOnGraphRX):
	
				if self.showRX:
					r = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphRX[j]
					self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-r, penRX )

				if self.showTX:
					t = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphTX[j]
					self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-t, penTX )
	
				x += self.pxLenGraph
				j += 1
		elif self.typeGraph == 1:
			penRX = QtGui.QPen( self.colorRX )
			penRX.setWidth( 2 )
			penTX = QtGui.QPen( self.colorTX )
			penTX.setWidth( 2 )

			while j < (len(self.viewPointOnGraphRX)-1):
	
				if self.showRX:
					r1 = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphRX[j+1]
					r0 = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphRX[j]
					self.scene.addLine( x+dx, self.Ly-r0, x+dx+self.pxLenGraph, self.Ly-r1, penRX )

				if self.showTX:
					t1 = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphTX[j+1]
					t0 = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphTX[j]
					self.scene.addLine( x+dx, self.Ly-t0, x+dx+self.pxLenGraph, self.Ly-t1, penTX )
	
				x += self.pxLenGraph
				j += 1

		self.X = self.X + self.pxLenGraph
		#print >> sys.stderr, "draw gr ok"

		#отрисовка сетки и системы координат
		self.drawSystemCoord()
		self.drawGrid(maxScaleY)
		
		#отрисовка линейки, если используется
		self.maxScaleY = maxScaleY
		#print >> sys.stderr, "drawMarkerScene"
		self.drawMarkerScene()
		#print >> sys.stderr, "drawMarkerScene ok"

		
		self.scene.update()
		#print >> sys.stderr, "update ok"

		#счетчик трафика
		if (self.rx1/1024) > 1048576:
			self.frm.lblInputValue.setText( "%.2f GB"%((self.rx1/1048576.0)/1024.0) )
		elif self.rx1 > 1048576:
			self.frm.lblInputValue.setText( "%.2f MB"%(self.rx1/1048576.0) )
		elif self.rx1 > 1024:
			self.frm.lblInputValue.setText( "%.2f kB"%(self.rx1/1024.0) )
		else:
			self.frm.lblInputValue.setText( "%s B"%(self.rx1) )
		
		if (self.tx1/1024) > 1048576:
			self.frm.lblOutputValue.setText( "%.2f GB"%((self.tx1/1048576.0)/1024.0) )
		elif self.tx1 > 1048576:
			self.frm.lblOutputValue.setText( "%.2f MB"%(self.tx1/1048576.0) )
		elif self.tx1 > 1024:
			self.frm.lblOutputValue.setText( "%.2f kB"%(self.tx1/1024.0) )
		else:
			self.frm.lblOutputValue.setText( "%s B"%(self.tx1) )
		
		#показания скорости
		#rx = (rx*1.0)/self.timeout
		#tx = (tx*1.0)/self.timeout 
		if rx > 1048576:
			self.frm.lblVinValue.setText( "%.2f MB/s"%(rx/1048576.0) )
		elif rx > 1024:
			self.frm.lblVinValue.setText( "%.2f kB/s"%(rx/1024.0) )
		else:
			self.frm.lblVinValue.setText( "%.2f B/s"%(rx) )
		
		if tx > 1048576:
			self.frm.lblVoutValue.setText( "%.2f MB/s"%(tx/1048576.0) )
		elif tx > 1024:
			self.frm.lblVoutValue.setText( "%.2f kB/s"%(tx/1024.0) )
		else:
			self.frm.lblVoutValue.setText( "%.2f B/s"%(tx) )
		#print >> sys.stderr, "setText ok"

		#print >> sys.stderr, ""

	
	def getTraffData(self, iface):
		rx = 0
		tx = 0

		gt = GetTraff(iface)
		self.rx1,self.tx1,okread = gt.getCurrBytes()

		rx = self.rx1 - self.rx0
		tx = self.tx1 - self.tx0
		#print time.time(), self.rx0, self.rx1
		#print time.time(), self.tx0, self.tx1

		self.rx0 = self.rx1
		self.tx0 = self.tx1

		return (rx, tx, okread)

	def actionForm(self):
		self.frm.pBrec.clicked.connect( self.dlgRecordData )
		self.frm.pbRecordStatus.clicked.connect( self.notifyRecNow )

		QtCore.QObject.connect(self.frm.actionRefreshInterval, QtCore.SIGNAL("triggered()"), self.dialogRefreshInterval)
		QtCore.QObject.connect(self.frm.actionIface, QtCore.SIGNAL("triggered()"), self.dialogIfaceSelect)
		
		# кнопка вызова диалога "Настройки монитора" и вся соответствующая ей хрень
		self.frm.pBopt.clicked.connect( self.dialogMonitorOptions )

		self.dlgMO = QtGui.QDialog()
		self.ui_dlgMO = MonitorOptions.Ui_DialogMonitorOptions( )
		self.ui_dlgMO.setupUi( self.dlgMO )

		self.ui_dlgMO.bGrGraphType.buttonPressed.connect( self.changeGrT )
		##XXX##self.ui_dlgMO.cbRuler.stateChanged.connect( self.changeRuler )
		self.ui_dlgMO.pbTraffRX.toggled.connect( self.changeShowRX )
		self.ui_dlgMO.pbTraffTX.toggled.connect( self.changeShowTX )
		self.ui_dlgMO.sbTimestamp.valueChanged.connect( self.changeTimestamp )

		pic = QtGui.QPixmap(":/pic128/pictures/2dowarrow_128.png")
		self.frm.lblInput.setPixmap( pic.scaled(32,32) )
		self.frm.lblIndexRX.setPixmap( pic.scaled(16,16) )
		self.frm.lblInput.setText("")
			
		pic = QtGui.QPixmap(":/pic128/pictures/2uparrow_128.png")
		self.frm.lblOutput.setPixmap( pic.scaled(32,32) )
		self.frm.lblIndexTX.setPixmap( pic.scaled(16,16) )
		self.frm.lblOutput.setText("")


	def changeShowRX(self, state):
		self.showRX = state
		self.qset.showRX( state )

	def changeShowTX(self, state):
		self.showTX = state
		self.qset.showTX( state )

	
	#-----------------#
	#вызывается, когда кликают на сцену
	def sceneMousePress(self, x, y):
		self.x_marker = x
		self.y_marker = y

		if self.itemLine != None:
			self.itemLine.hide()
			self.itemLine = None
		if self.itemBox != None:
			self.itemBox.hide()
			self.itemBox = None
		if self.itemText != None:
			self.itemText.hide()
			self.itemText = None
		self.drawMarkerScene()
	

	def drawMarkerScene(self):
		x = self.x_marker
		y = self.y_marker

		if self.showMarker:
			val = (self.maxScaleY - (1.0*y / self.Ly )*self.maxScaleY)
			if val < 0:
				val = 0
			if val > 1048576:
				val = "%.2f MB/s"%( val/1048576.0 )
			elif val > 1024:
				val = "%.2f kB/s"%(val/1024.0)
			else:
				val = "%.2f B/s"%(val)
			self.itemLine = self.scene.addLine( 0, y, self.Lx, y, self.pen_marker )
			dy = 10
			if y < 20:
				dy = -15
			self.itemBox = self.scene.addLine( x+15, y-dy, x+80, y-dy, self.bx_marker )
			self.itemText = self.scene.addText( "%s"%val, self.font_marker )
			self.itemText.setPos( x+15, (y-(dy+12)) )
		else:
			self.itemLine = None
			self.itemBox = None
			self.itemText = None
	
	#-----------------#
	def dialogRefreshInterval(self):
		self.dlg = QtGui.QDialog( )
		self.ui_dlg = DialogRefreshInterval.Ui_Dialog()
		self.ui_dlg.setupUi( self.dlg )
		#self.ui_dlg.lblValue.setText( "%s sec"%self.timeout )
		self.ui_dlg.pbOk.clicked.connect( self.setTimeoutDlg )
		self.ui_dlg.listWidgetUpdateInterval.itemClicked.connect( self.itemClickedRefreshInterval )
		if self.timeout > 0 and self.timeout <= 5:
			self.ui_dlg.listWidgetUpdateInterval.setCurrentRow( (self.timeout-1) )
		self.dlg.show()
		self.dlg.exec_()

	def itemClickedRefreshInterval(self):
		int = self.ui_dlg.listWidgetUpdateInterval.currentRow()
		#self.ui_dlg.lblValue.setText( "%s sec"%(int+1) )

	def setTimeoutDlg(self):
		self.dlg.hide()
		self.timer.stop()
		self.timeout = (self.ui_dlg.listWidgetUpdateInterval.currentRow()+1)
		#self.ui_dlg.lblValue.setText( "%s sec"%self.timeout )
		self.scene.clear()
		self.viewPointOnGraphRX.clear()
		self.viewPointOnGraphTX.clear()
		self.drawGraph()
		self.X=0
		self.timer.start( self.timeout*1000 )

		self.frm.lblRefreshVal.setText( "%s sec"%self.timeout )

		txt1 = QtGui.QApplication.translate("ViewCurrentSessionExt", "Refresh interval:", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("ViewCurrentSessionExt", "sec", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s %s %s"%(txt1, self.timeout, txt2) )

	#-----------------#
	def dialogMonitorOptions(self):
		#смена вида графика
		if self.qset.isTypeGrapStat():
			self.ui_dlgMO.rbTypeStat.setChecked( True )
			self.typeGraph = 0
		else:
			self.ui_dlgMO.rbTypeTime.setChecked( True )
			self.typeGraph = 1

		#включение линейки
		if self.qset.isShowRuler():
			##XXX##self.ui_dlgMO.cbRuler.setCheckState( QtCore.Qt.Checked )
			self.showMarker = True
			self.qset.showRuler( True )
		else:
			##XXX##self.ui_dlgMO.cbRuler.setCheckState( QtCore.Qt.Unchecked )
			self.showMarker = False
			self.qset.showRuler( False )

		#Отображение графиков
		if self.showRX:
			self.ui_dlgMO.pbTraffRX.setChecked( True )
			self.qset.showRX( True )
		else:
			self.ui_dlgMO.pbTraffRX.setChecked( False )
			self.qset.showRX( False )
		
		if self.showTX:
			self.ui_dlgMO.pbTraffTX.setChecked( True )
			self.qset.showTX( True )
		else:
			self.ui_dlgMO.pbTraffTX.setChecked( False )
			self.qset.showTX( False )

		#Отображение значений временной метки
		self.ui_dlgMO.sbTimestamp.setValue( self.qset.timestamp() )

		self.dlgMO.show()
		self.dlgMO.exec_()

	#изменение вида графика
	def changeGrT(self, button):
		if button == self.ui_dlgMO.rbTypeTime:
			self.qset.setTypeGraphTime()
			self.typeGraph = 1
		elif button == self.ui_dlgMO.rbTypeStat:
			self.qset.setTypeGraphStat()
			self.typeGraph = 0
	
	#изменение видимости линейки
	def changeRuler(self, state ):
		if state == QtCore.Qt.Checked:
			self.showMarker = True
			self.qset.showRuler( True )
		else:
			self.showMarker = False
			self.qset.showRuler( False )

	#изменения значений временных меток
	def changeTimestamp( self, value ):
		self.qset.setTimestamp( "%s"%value )
		self.timestamp = (int)(value)

	#-----------------#
	def dialogIfaceSelect(self):
		self.dlgIface = QtGui.QDialog()
		self.ui_dlgIface = DialogNetworkIface.Ui_dlgNetworkSelect()
		self.ui_dlgIface.setupUi( self.dlgIface )
		
		self.ui_dlgIface.pB_ok.clicked.connect( self.okDlgNetworkIface )
		#init list iface
		self.ui_dlgIface.lWIface.clear()
		listSupportIface = self.db.optGetSupportIface()
		for i in listSupportIface:
			item_pic = StatistData.pixmapIface_pic( i['iface'] )
			item = QtGui.QListWidgetItem( QtGui.QIcon(item_pic), i['iface'] )
			self.ui_dlgIface.lWIface.addItem( item )
		
		self.ui_dlgIface.lblIface.setText( "%s"%self.iface )
		self.ui_dlgIface.lblIfacePixmap.setPixmap( StatistData.pixmapIface_pic(self.iface) )
		i = self.ui_dlgIface.lWIface.findItems( "%s"%self.iface, QtCore.Qt.MatchExactly)
		if len(i) > 0:
			self.ui_dlgIface.lWIface.setCurrentItem( i[0] )
		
		self.ui_dlgIface.lWIface.itemClicked.connect( self.itemClickedNetworkIface )
		
		self.dlgIface.show()
		self.dlgIface.exec_()

	def itemClickedNetworkIface(self, item):
		self.ui_dlgIface.lblIface.setText( item.text() )
		self.ui_dlgIface.lblIfacePixmap.setPixmap( StatistData.pixmapIface_pic( item.text() ) )

	def cancelDlgNetworkIface(self):
		self.dlgIface.hide()
	
	def okDlgNetworkIface(self):
		self.viewPointOnGraphRX.clear()
		self.viewPointOnGraphTX.clear()
		self.dlgIface.hide()
		self.timer.stop()
		try:
			iface_item = self.ui_dlgIface.lWIface.currentItem().text()
			self.iface = iface_item
		except Exception:
			pass
		self.getTraffData( self.iface )
		self.X=0
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface ) #включена ли запись на сетевом интерфейсе
		except:
			self.statusRecDBus = False
		self.timer.start( self.timeout*1000 )

		txt = QtGui.QApplication.translate("ViewCurrentSessionExt", "Selected network interface:", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s %s"%(txt, self.iface) )


	#-----------------#
	def dlgRecordData(self):
		self.dlgRec = QtGui.QDialog()
		self.ui_dlgRec = DialogRecordDataExt.DialogRecordManagerExt( self.dlgRec, self.db, self.mydbus )
		#XXX# вроде уже не нужно, т.к. изменение записи определяется приемом dbus сигналов
		#self.ui_dlgRec.stateRecordChange.connect( self.stateRecordChangeHere )
		self.dlgRec.show()
		self.dlgRec.exec_()

	#-----------------#
	def dbusWaitDisplayOff(self):
		try:
			bus = dbus.SystemBus()
			remote_object = bus.get_object( "com.nokia.mce", "/com/nokia/mce/signal" )
			iface = dbus.Interface( remote_object, "com.nokia.mce.signal" )
			iface.connect_to_signal("display_status_ind", self.dbusDisplayHandler)
		except dbus.DBusException, e:
			print "ViewCurrentSessionExt::dbusWaitDisplayOff(): Except: %s"%e
	
	def dbusDisplayHandler(self, statusDisplay):
		if statusDisplay == "off":
			self.hide()

	#-----------------#
	def actionRecIndicator(self):
		if self.showRec:
			self.frm.widgetRecordStatus.hide()
			self.showRec = False
		else:
			self.frm.widgetRecordStatus.show()
			self.showRec = True
	
	def stateRecordChangeHere(self):
		#поступил qt-сигнал изменения состояния записи на сетевом интерфейсе
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface )
		except:
			self.statusRecDBus = False

	def notifyRecNow(self):
		txt = QtGui.QApplication.translate("ViewCurrentSessionExt", "Recording...", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%(txt) )


