#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui
import WindowFilterOptions
import DateWindowExt
from gettraff import GetTraff
import myconfig

class WindowFilterOptionsExt( QtGui.QMainWindow ):
	def __init__(self, parent, parentUi ):
		QtGui.QMainWindow.__init__(self, parent)

		self.parentUI = parentUi
		self.parent = parent
				
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
		except Exception, e:
			pass
			#print "WindowFilterOptionsExt::__init__(): Exception setAttribute(): ", e

		self.ui = WindowFilterOptions.Ui_MainWindow()
		self.ui.setupUi( self )
		self.actionForm()

		#self.setWindowTitle( "Filter options" )


	def actionForm(self):
		self.ui.dTEStart.setDateTime( QtCore.QDateTime.currentDateTime() )
		self.ui.dTEEnd.setDateTime( QtCore.QDateTime.currentDateTime() )

		if self.ui.cBStart.checkState() == QtCore.Qt.Checked:
			self.ui.dTEStart.setEnabled( True )
			self.ui.pBCalStart.setEnabled( True )
		else:
			self.ui.dTEStart.setEnabled( False )
			self.ui.pBCalStart.setEnabled( False )
		
		if self.ui.cBEnd.checkState() == QtCore.Qt.Checked:
			self.ui.dTEEnd.setEnabled( True )
			self.ui.pBCalEnd.setEnabled( True )
		else:
			self.ui.dTEEnd.setEnabled( False )
			self.ui.pBCalEnd.setEnabled( False )

		self.ui.cBStart.stateChanged.connect( self.changeStartCB )
		self.ui.cBEnd.stateChanged.connect( self.changeEndCB )


		self.ui.pBCancel.clicked.connect( self.cancelFilter )
		self.ui.pBAccept.clicked.connect( self.acceptFilter )

		self.ui.pBCalStart.clicked.connect( self.winCalStartDate )
		self.ui.pBCalEnd.clicked.connect( self.winCalEndDate )

		self.ui.lWIface.clear()
		item = QtGui.QListWidgetItem( QtGui.QIcon(QtGui.QPixmap(":/pic48/pictures/unknown.png")), "All" )
		self.ui.lWIface.addItem( item )
		item.setData( QtCore.Qt.UserRole+1, 0 )
		listSupportIface = self.parent.db.optGetSupportIface()
		for i in listSupportIface:
			if i['iface'] == 'gprs0':
				item_pic = ":/pic48/pictures/gprs.png"
			elif i['iface'] == "wlan0":
				item_pic = ":/pic48/pictures/wifi.png"
			elif i['iface'] == "pan0":
				item_pic = ":/pic48/pictures/pan.png"
			elif ( i['iface'] == "eth0" ):
				item_pic = ":/pic48/pictures/eth.png"
			elif ( i['iface'] == "usb0" ):
				item_pic = ":/pic48/pictures/usb.png"
			else:
				item_pic = ":/pic48/pictures/unknown.png"
			item = QtGui.QListWidgetItem( QtGui.QIcon(QtGui.QPixmap(item_pic)), i['iface'] )
			item.setData( QtCore.Qt.UserRole+1, i['type'] )
			self.ui.lWIface.addItem( item )
		self.ui.lWIface.setCurrentRow(0)



	def changeStartCB(self, state ):
		if state:
			self.ui.dTEStart.setEnabled( True )
			self.ui.pBCalStart.setEnabled( True )
		else:
			self.ui.dTEStart.setEnabled( False )
			self.ui.pBCalStart.setEnabled( False )

	def changeEndCB(self, state ):
		if state:
			self.ui.dTEEnd.setEnabled( True )
			self.ui.pBCalEnd.setEnabled( True )
		else:
			self.ui.dTEEnd.setEnabled( False )
			self.ui.pBCalEnd.setEnabled( False )

	def acceptFilter(self):
		n = self.ui.lWIface.currentRow()
		item = self.ui.lWIface.item( n )
		item_num = item.data( QtCore.Qt.UserRole+1 )

		self.parentUI.pBFilter.setChecked( True )
		self.hide()
		if (self.ui.cBStart.checkState() == QtCore.Qt.Checked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Checked):
			startDT = self.ui.dTEStart.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			endDT = self.ui.dTEEnd.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(startDT, endDT, item_num)
		elif (self.ui.cBStart.checkState() == QtCore.Qt.Checked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Unchecked):
			startDT = self.ui.dTEStart.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(startDT, None, item_num)
		elif (self.ui.cBStart.checkState() == QtCore.Qt.Unchecked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Checked):
			endDT = self.ui.dTEEnd.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(None, endDT, item_num)
		else:
			self.parent.initItemsSession(None, None, item_num)

	def cancelFilter(self):
		self.parentUI.pBFilter.setChecked( False )
		self.hide()


	def winCalStartDate(self):
		self.wDate = DateWindowExt.DateWindowExt( self, self.ui.dTEStart )
		self.wDate.show()
	
	def winCalEndDate(self):
		self.wDate = DateWindowExt.DateWindowExt( self, self.ui.dTEEnd )
		self.wDate.show()
