#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui

from MyNotify import MyNotify
import ViewCurrentSession
import DialogRefreshInterval
import DialogNetworkIface
import DialogRecordDataExt
import StatistData

from collections import deque

import dbus

from gettraff import GetTraff
from mydb import MyDB
import myconfig


class ViewCurrentSessionExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydbus, iface='gprs0'):
		QtGui.QMainWindow.__init__(self, parent)

		self.mydbus = mydbus
		self.db = MyDB( myconfig.file_db )

		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
		except Exception, e:
			pass
			#print "ViewCurrentSessionExt::__init__(): Exception setAttribute(): ",e

		self.frm = ViewCurrentSession.Ui_ViewCurrentSession()
		self.frm.setupUi( self )
		self.actionForm()

		listSupportIface = self.db.optGetSupportIface()
		if len(listSupportIface) != 0:
			self.iface = listSupportIface[0]['iface']
		else:
			self.iface = iface
		
		self.setWindowTitle( self.iface )

		self.rx0 = 0
		self.rx1 = 0
		self.tx0 = 0
		self.tx1 = 0
		self.maxRX = 0
		self.maxTX = 0
		self.getTraffData( self.iface )

		#установки таймера, периодичности получения данных
		self.timeout = 2 #sec
		self.timer = QtCore.QTimer()
		QtCore.QObject.connect( self.timer, QtCore.SIGNAL("timeout()"), self.drawGraph )
		self.timer.start( self.timeout * 1000 )

		#таймер индикатора записи
		self.timeoutRecIndicator = 1 #sec
		self.timerRecIndicator = QtCore.QTimer()
		QtCore.QObject.connect( self.timerRecIndicator, QtCore.SIGNAL("timeout()"), self.actionRecIndicator )
		self.statusRecDBus = False
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface )
		except Exception:
			pass
		self.showRec = True
		self.frm.widgetRecordStatus.hide()

		#деки - очереди, содержащие данные, отображаемые на графике
		self.viewPointOnGraphRX = deque([])
		self.viewPointOnGraphTX = deque([])

		#геомертические параметры отображаемого графика
		self.lengthX = 770
		self.lengthY = 280
		self.shiftX = 0
		self.shiftY = 10
		
		#вспомогательные переменные
		#длина графика по оси Y
		self.Ly = self.lengthY-self.shiftY
		#длина графика по оси X
		self.Lx = self.lengthX-self.shiftX

		self.X=0
		self.scene = QtGui.QGraphicsScene()
		self.frm.graphicsView.setScene(self.scene)
		self.frm.graphicsView.setSceneRect(0, 0, self.lengthX, self.lengthY)
		self.frm.graphicsView.centerOn(0,0)

		self.showRX = True
		self.showTX = True

		#ширина линии графика (пиксель)
		self.pxLenGraph = 5

		self.noti = MyNotify()

		self.dbusWaitDisplayOff()
	
#	def startTimer(self):
#		self.timer.start( self.timeout * 1000 )
#	
#	def startTimer(self):
#		self.timer.stop( )

	
	def drawSystemCoord(self):
		pen = QtGui.QPen( QtGui.QColor(100,100,100) )
		pen.setWidth(4)

		delta = self.shiftX
		self.scene.addLine(delta, self.lengthY-self.shiftY, self.lengthX, self.lengthY-self.shiftY, pen) #X - time
		self.scene.addLine(delta, 0+delta, delta, self.lengthY-delta, pen) #Y - Bytes


	def drawGrid(self, maxScaleY):
		pen = QtGui.QPen( QtGui.QColor(170,170,170) )
		pen.setWidth(1)
		pen.setStyle( QtCore.Qt.DotLine )

		font = QtGui.QFont()
		font.setPointSize(9)

		x = 0
		while x < self.lengthX:
			self.scene.addLine( x+self.shiftX, 0, x+self.shiftX, self.lengthY - self.shiftY, pen )
			x += (30/self.timeout)*self.pxLenGraph # 1 расстояние между вертикальными линиями сетки - 30 сек
			
		
		partY = 4
		stepLineY = self.Ly/(partY) #шаг горизонтально (по оси Y) линии сетки
		currY = self.Ly
		it = 0
		myMaxScaleY = maxScaleY/partY
		while it < (partY+1):
			self.scene.addLine( self.shiftX, self.Ly-currY, self.lengthX, self.Ly-currY, pen )
			txt = ""
			if( maxScaleY > 1024 ):
				txt = "%s kB/s"%( it*myMaxScaleY/1024 ) 
			else:
				txt = "%s B/s"%( it*myMaxScaleY ) 
			self.scene.addText( txt, font ).setPos( self.shiftX, currY )
			
			currY = currY - stepLineY
			it += 1



	def drawGraph(self):
		#цвета графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		self.frm.lblColorRX.setStyleSheet("background-color: %s;"%(rgbRX) )
		self.frm.lblColorTX.setStyleSheet("background-color: %s;"%(rgbTX) )

		penRX = QtGui.QPen( self.colorRX )
		penRX.setWidth( self.pxLenGraph )
		penTX = QtGui.QPen( self.colorTX )
		penTX.setWidth( self.pxLenGraph )

		dx = self.shiftX + self.pxLenGraph/2

		self.scene.clear()

		#получаем результат - переводим его в скорость: байт/сек
		rx,tx,ok = self.getTraffData( self.iface )
		if ok:
			self.setWindowTitle( "%s - online"%self.iface )
			if ( (self.timerRecIndicator.isActive() == False) and (self.statusRecDBus) ):
				self.timerRecIndicator.start( self.timeoutRecIndicator*1000 )
			elif ( (self.timerRecIndicator.isActive()) and (self.statusRecDBus == False) ):
				self.timerRecIndicator.stop()
				self.frm.widgetRecordStatus.hide()
		else:
			self.setWindowTitle( "%s - offline"%self.iface )
			if self.timerRecIndicator.isActive() == True:
				self.timerRecIndicator.stop()
				self.frm.widgetRecordStatus.hide()
		rx = (rx*1.0)/self.timeout
		tx = (tx*1.0)/self.timeout 

		# проталкиваем очередное полученное значение в очередь
		if( (self.X+dx) > self.lengthX ):
			try:
				self.viewPointOnGraphRX.popleft()
			except:
				pass
			try:
				self.viewPointOnGraphTX.popleft()
			except:
				pass
			self.X = self.lengthX
		self.viewPointOnGraphRX.append( rx )
		self.viewPointOnGraphTX.append( tx )

		# берем максимальное значение из каждой очереди если они рисуются обе,
		# иначе, макс. занчение графика, очередь которого будет отображаться
		maxRXTX = 0
		if self.showRX and self.showTX:
			self.maxRX = max( self.viewPointOnGraphRX )
			self.maxTX = max( self.viewPointOnGraphTX )
			maxRXTX = max(self.maxRX, self.maxTX)
		elif self.showRX and (self.showTX == False):
			self.maxRX = max( self.viewPointOnGraphRX )
			maxRXTX = self.maxRX
		elif (self.showRX==False) and self.showTX:
			self.maxTX = max( self.viewPointOnGraphTX )
			maxRXTX = self.maxTX

		# высчитываем масштабный коэффициент
		m = 1
		while True:
			if maxRXTX <= (2**m):
				break
			m += 1
		maxScaleY = 2**m

		#отрисовка значений, заполняющих каждую деку входящего/исходящего трафика
		x=0
		j=0
		while j < len(self.viewPointOnGraphRX):

			if self.showRX:
				r = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphRX[j]
				self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-r, penRX )

			if self.showTX:
				t = (self.Ly*(1.0 / maxScaleY))*self.viewPointOnGraphTX[j]
				self.scene.addLine( x+dx, self.Ly, x+dx, self.Ly-t, penTX )

			x += self.pxLenGraph
			j += 1
		self.X = self.X + self.pxLenGraph

		#отрисовка сетки и системы координат
		self.drawSystemCoord()
		self.drawGrid(maxScaleY)
		
		self.scene.update()

		#счетчик трафика
		if (self.rx1/1024) > 1048576:
			self.frm.lblInputValue.setText( "%.2f TB"%((self.rx1/1048576.0)/1024.0) )
		elif self.rx1 > 1048576:
			self.frm.lblInputValue.setText( "%.2f MB"%(self.rx1/1048576.0) )
		elif self.rx1 > 1024:
			self.frm.lblInputValue.setText( "%.2f kB"%(self.rx1/1024.0) )
		else:
			self.frm.lblInputValue.setText( "%s B"%(self.rx1) )
		
		if (self.tx1/1024) > 1048576:
			self.frm.lblOutputValue.setText( "%.2f TB"%((self.tx1/1048576.0)/1024.0) )
		elif self.tx1 > 1048576:
			self.frm.lblOutputValue.setText( "%.2f MB"%(self.tx1/1048576.0) )
		elif self.tx1 > 1024:
			self.frm.lblOutputValue.setText( "%.2f kB"%(self.tx1/1024.0) )
		else:
			self.frm.lblOutputValue.setText( "%s B"%(self.tx1) )
		
		#показания скорости
		#rx = (rx*1.0)/self.timeout
		#tx = (tx*1.0)/self.timeout 
		if rx > 1048576:
			self.frm.lblVinValue.setText( "%.2f MB/s"%(rx/1048576.0) )
		elif rx > 1024:
			self.frm.lblVinValue.setText( "%.2f kB/s"%(rx/1024.0) )
		else:
			self.frm.lblVinValue.setText( "%.2f B/s"%(rx) )
		
		if tx > 1048576:
			self.frm.lblVoutValue.setText( "%.2f MB/s"%(tx/1048576.0) )
		elif tx > 1024:
			self.frm.lblVoutValue.setText( "%.2f kB/s"%(tx/1024.0) )
		else:
			self.frm.lblVoutValue.setText( "%.2f B/s"%(tx) )

	
	def getTraffData(self, iface):
		rx = 0
		tx = 0

		gt = GetTraff(iface)
		self.rx1,self.tx1,okread = gt.getCurrBytes()

		rx = self.rx1 - self.rx0
		tx = self.tx1 - self.tx0
		#print time.time(), self.rx0, self.rx1
		#print time.time(), self.tx0, self.tx1

		self.rx0 = self.rx1
		self.tx0 = self.tx1

		return (rx, tx, okread)

	def actionForm(self):
		self.frm.pBshowRX.clicked.connect( self.changeShowRX )
		self.frm.pBshowTX.clicked.connect( self.changeShowTX )
		self.frm.pBrec.clicked.connect( self.dlgRecordData )
		self.frm.pbRecordStatus.clicked.connect( self.notifyRecNow )

		QtCore.QObject.connect(self.frm.actionRefreshInterval, QtCore.SIGNAL("triggered()"), self.dialogRefreshInterval)
		QtCore.QObject.connect(self.frm.actionIface, QtCore.SIGNAL("triggered()"), self.dialogIfaceSelect)
		
		#self.dlgRec = QtGui.QDialog()
		#self.ui_dlgRec = DialogRecordDataExt.DialogRecordManagerExt( self.dlgRec, self.mydbus )
		#self.ui_dlgRec.stateRecordChange.connect( self.stateRecordChangeHere )

	def changeShowRX(self):
		if self.showRX:
			self.showRX = False
		else:
			self.showRX = True

	def changeShowTX(self):
		if self.showTX:
			self.showTX = False
		else:
			self.showTX = True

	#-----------------#
	def dialogRefreshInterval(self):
		self.dlg = QtGui.QDialog( )
		self.ui_dlg = DialogRefreshInterval.Ui_Dialog()
		self.ui_dlg.setupUi( self.dlg )
		#self.ui_dlg.lblValue.setText( "%s sec"%self.timeout )
		self.ui_dlg.pbOk.clicked.connect( self.setTimeoutDlg )
		self.ui_dlg.listWidgetUpdateInterval.itemClicked.connect( self.itemClickedRefreshInterval )
		if self.timeout > 0 and self.timeout <= 5:
			self.ui_dlg.listWidgetUpdateInterval.setCurrentRow( (self.timeout-1) )
		self.dlg.show()
		self.dlg.exec_()

	def itemClickedRefreshInterval(self):
		int = self.ui_dlg.listWidgetUpdateInterval.currentRow()
		#self.ui_dlg.lblValue.setText( "%s sec"%(int+1) )

	def setTimeoutDlg(self):
		self.dlg.hide()
		self.timer.stop()
		self.timeout = (self.ui_dlg.listWidgetUpdateInterval.currentRow()+1)
		#self.ui_dlg.lblValue.setText( "%s sec"%self.timeout )
		self.scene.clear()
		self.viewPointOnGraphRX.clear()
		self.viewPointOnGraphTX.clear()
		self.drawGraph()
		self.X=0
		self.timer.start( self.timeout*1000 )

		self.frm.lblRefreshVal.setText( "%s sec"%self.timeout )

		txt1 = QtGui.QApplication.translate("ViewCurrentSessionExt", "Refresh interval:", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("ViewCurrentSessionExt", "sec", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s %s %s"%(txt1, self.timeout, txt2) )

	#-----------------#
	def dialogIfaceSelect(self):
		self.dlgIface = QtGui.QDialog()
		self.ui_dlgIface = DialogNetworkIface.Ui_dlgNetworkSelect()
		self.ui_dlgIface.setupUi( self.dlgIface )
		
		self.ui_dlgIface.pB_ok.clicked.connect( self.okDlgNetworkIface )
		#init list iface
		self.ui_dlgIface.lWIface.clear()
		listSupportIface = self.db.optGetSupportIface()
		for i in listSupportIface:
			if i['iface'] == "gprs0":
				item_pic = QtGui.QPixmap(":/pic48/pictures/gprs.png" )
			elif i['iface'] == "wlan0":
				item_pic = QtGui.QPixmap(":/pic48/pictures/wifi.png" )
			elif i['iface'] == "pan0":
				item_pic = QtGui.QPixmap(":/pic48/pictures/pan.png" )
			elif i['iface'] == "eth0":
				item_pic = QtGui.QPixmap(":/pic48/pictures/eth.png" )
			elif i['iface'] == "usb0":
				item_pic = QtGui.QPixmap(":/pic48/pictures/usb.png" )
			else:
				item_pic = QtGui.QPixmap(":/pic48/pictures/unknown.png" )
			item = QtGui.QListWidgetItem( QtGui.QIcon(item_pic), i['iface'] )
			self.ui_dlgIface.lWIface.addItem( item )
		
		self.ui_dlgIface.lblIface.setText( "%s"%self.iface )
		self.ui_dlgIface.lblIfacePixmap.setPixmap( StatistData.pixmapIface(self.iface) )
		i = self.ui_dlgIface.lWIface.findItems( "%s"%self.iface, QtCore.Qt.MatchExactly)
		if len(i) > 0:
			self.ui_dlgIface.lWIface.setCurrentItem( i[0] )
		
		self.ui_dlgIface.lWIface.itemClicked.connect( self.itemClickedNetworkIface )
		
		self.dlgIface.show()
		self.dlgIface.exec_()

	def itemClickedNetworkIface(self, item):
		self.ui_dlgIface.lblIface.setText( item.text() )
		self.ui_dlgIface.lblIfacePixmap.setPixmap( StatistData.pixmapIface( item.text() ) )

	def cancelDlgNetworkIface(self):
		self.dlgIface.hide()
	
	def okDlgNetworkIface(self):
		self.viewPointOnGraphRX.clear()
		self.viewPointOnGraphTX.clear()
		self.dlgIface.hide()
		self.timer.stop()
		try:
			iface_item = self.ui_dlgIface.lWIface.currentItem().text()
			self.iface = iface_item
		except Exception:
			pass
		self.getTraffData( self.iface )
		self.X=0
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface ) #включена ли запись на сетевом интерфейсе
		except:
			self.statusRecDBus = False
		self.timer.start( self.timeout*1000 )

		txt = QtGui.QApplication.translate("ViewCurrentSessionExt", "Selected network interface:", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s %s"%(txt, self.iface) )


	#-----------------#
	def dlgRecordData(self):
		self.dlgRec = QtGui.QDialog()
		self.ui_dlgRec = DialogRecordDataExt.DialogRecordManagerExt( self.dlgRec, self.mydbus )
		self.ui_dlgRec.stateRecordChange.connect( self.stateRecordChangeHere )
		self.dlgRec.show()
		self.dlgRec.exec_()

	#-----------------#
	def dbusWaitDisplayOff(self):
		try:
			bus = dbus.SystemBus()
			remote_object = bus.get_object( "com.nokia.mce", "/com/nokia/mce/signal" )
			iface = dbus.Interface( remote_object, "com.nokia.mce.signal" )
			iface.connect_to_signal("display_status_ind", self.dbusDisplayHandler)
		except dbus.DBusException, e:
			print "ViewCurrentSessionExt::dbusWaitDisplayOff(): Except: %s"%e
	
	def dbusDisplayHandler(self, statusDisplay):
		if statusDisplay == "off":
			self.hide()

	#-----------------#
	def actionRecIndicator(self):
		if self.showRec:
			self.frm.widgetRecordStatus.hide()
			self.showRec = False
		else:
			self.frm.widgetRecordStatus.show()
			self.showRec = True
	
	def stateRecordChangeHere(self):
		#поступил qt-сигнал изменения состояния записи на сетевом интерфейсе
		try:
			self.statusRecDBus = self.mydbus.recStatus( self.iface )
		except:
			self.statusRecDBus = False

	def notifyRecNow(self):
		txt = QtGui.QApplication.translate("ViewCurrentSessionExt", "Recording...", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%(txt) )


