import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings") + " - " + qsTr("Other")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height }
        contentWidth: parent.width
        contentHeight: col1.height
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right }
            spacing: 20

            SelectionItem {
                id: orientationSelector

                title: qsTr("Screen orientation")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Auto"); value: "auto" }
                    ListElement { name: QT_TR_NOOP("Landscape"); value: "landscape" }
                    ListElement { name: QT_TR_NOOP("Portrait"); value: "portrait" }
                }
                initialValue: Settings.screenOrientation
                onValueChosen: Settings.screenOrientation = value
            }

            SelectionItem {
                id: scrollSelector

                title: qsTr("Scrolling speed")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Slowest"); value: 1500 }
                    ListElement { name: QT_TR_NOOP("Slow"); value: 2000 }
                    ListElement { name: QT_TR_NOOP("Medium"); value: 2500 }
                    ListElement { name: QT_TR_NOOP("Fast"); value: 3000 }
                    ListElement { name: QT_TR_NOOP("Fastest"); value: 3500 }
                }
                initialValue: Settings.maximumFlickVelocity
                onValueChosen: Settings.maximumFlickVelocity = value
            }

            SelectionItem {
                id: languageSelector

                title: qsTr("Language")
                model: ListModel {}
                onValueChosen: Settings.language = value
                Component.onCompleted: {
                    var languages = Settings.getLanguages();
                    for (var i = 0; i < languages.length; i++) {
                        model.append(languages[i]);
                    }
                    setInitialValue(Settings.language);
                }
            }
        }
    }
}
