import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property variant videoFeeds
    property Item youtubePage: null
    property Item dailymotionPage: null

    function setVideoFeeds(feeds) {
        videoFeeds = feeds;
        if (feeds.site == "youtube") {
            loadYouTubeVideos();
        }
        else {
            loadDailymotionVideos();
        }
    }

    function loadYouTubeVideos() {
        youtubePage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 0);
        youtubePage.setVideoFeed(videoFeeds.youtube);
    }

    function loadDailymotionVideos() {
        dailymotionPage = tabGroup.addTab(Qt.resolvedUrl("DMListPage.qml"), 1);
        dailymotionPage.setVideoFeed(videoFeeds.dailymotion);
    }

    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                text: "YouTube"
                checked: tabGroup.index == 0
                onClicked: if (youtubePage === null) loadYouTubeVideos(); else tabGroup.setTab(0);
            },

            TabButton {
                text: "Dailymotion"
                checked: tabGroup.index == 1
                onClicked: if (dailymotionPage === null) loadDailymotionVideos(); else tabGroup.setTab(1);
            }
        ]
    }
}
