import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: delegate

    signal clicked
    signal pressAndHold

    opacity: mouseArea.pressed ? 0.5 : 1

    Image {
        id: frame

        z: 1
        anchors { fill: delegate; margins: 5 }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: thumbnail_large_url
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = !theme.inverted ? "images/video.png" : "images/video-white.png";
            visible: status == Image.Ready

            Rectangle {
                id: background

                height: titleText.height + 6
                anchors { bottom: thumb.bottom; left: thumb.left; right: thumb.right }
                color: "black"
                opacity: 0.5
                smooth: true
            }

            Label {
                id:titleText

                anchors { left: background.left; leftMargin: 5; right: background.right; rightMargin: 5; verticalCenter: background.verticalCenter }
                text: title
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                verticalAlignment: Text.AlignVCenter
                elide: Text.ElideRight
                smooth: true
            }

            Rectangle {
                id: durationBackground
                width: durationText.width + 10
                height: 22
                anchors { top: thumb.top; right: thumb.right; margins: 10 }
                color: "black"
                opacity: 0.5
                radius: 5
                smooth: true
            }

            Label {
                id: durationText

                anchors.centerIn: durationBackground
                text: DT.getDuration(duration)
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                smooth: true
            }
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

