import QtQuick 1.0

Item {
    id: button

    property bool useTheme: true
    property bool enabled: true
    property alias title: title.text
    property alias model: selectionDialog.model
    property string initialValue
    property string currentValue
    property bool closeMenuWhenClicked: true
    property bool checked: false
    property bool checkable: false

    signal valueChosen(string value)
    signal clicked
    signal pressAndHold

    width: appWindow.inPortrait ? parent.width : Math.floor(parent.width / 2) - 5
    height: 70
    opacity: enabled ? 1 : 0.3

    Rectangle {
        id: background

        anchors.fill: button
        radius: 10
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: button.useTheme ? Settings.gradientColorHigh : "#524e4e" }
            GradientStop { id: gradient2; position: 0.7; color: button.useTheme ? Settings.gradientColor : "black"}
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
        state: (mouseArea.pressed) || (checked) ? "highlight" : ""

        states: State {
            name: "highlight"
            PropertyChanges { target: gradient1; color: Qt.lighter(Settings.activeColor, 1.2) }
            PropertyChanges { target: gradient2; color: Settings.activeColor }
        }
    }

    function setInitialValue(value) {
        var found = false;
        var i = 0;
        while ((!found) && (i < model.count)) {
            if (model.get(i).value == value) {
                selectionDialog.selectedIndex = i;
                found = true;
            }
            i++;
        }
        currentValue = value;
    }

    Component.onCompleted: if (initialValue != "") setInitialValue(initialValue);

    ListHighlight {
        visible: mouseArea.pressed
    }

    Column {

        anchors { left: parent.left; leftMargin: 10; right: icon.left; rightMargin: 10; verticalCenter: parent.verticalCenter }

        Label {
            id: title

            
            
            verticalAlignment: Text.AlignVCenter
        }

        Label {
            id: subTitle

            width: parent.width
            color: "#4d4d4d"
            font.pixelSize: _SMALL_FONT_SIZE
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
            text: selectionDialog.selectedIndex < 0 ? "" : model.get(selectionDialog.selectedIndex).name
        }
    }

    Image {
        id: icon

        anchors { right: parent.right; rightMargin: 20; verticalCenter: parent.verticalCenter }
        source: Settings.appTheme == "light" ? "../images/icon-m-common-combobox-arrow.png" : "../images/icon-m-textinput-combobox-arrow.png"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        enabled: parent.enabled
        onClicked: {
            parent.clicked();
            selectionDialog.open();
        }
    }

    SelectionDialog {
        id: selectionDialog

        titleText: title.text
        onValueChosen: button.valueChosen(value)
    }

    onClicked: if (closeMenuWhenClicked) pageStack.currentPage.tools.close();
}



