import QtQuick 1.0

Item {

    signal clicked

    width: parent.width
    height: 80

    ListHighlight {
        visible: mouseArea.pressed
    }

    Image {
        id: icon

        anchors { left: parent.left; leftMargin: 10; verticalCenter: parent.verticalCenter }
        source: parent.ListView.view.model.isFolder(index) ? Settings.appTheme == "light" ? "../images/folder.png" : "../images/folder-white.png" : Settings.appTheme == "light" ? "../images/videofile.png" : "../images/videofile-white.png"
    }

    Label {
        anchors { left: icon.right; leftMargin: 10; right: parent.right; rightMargin: 10; verticalCenter: parent.verticalCenter }
        font.bold: true
        
        elide: Text.ElideRight
        text: fileName
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}
