import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item infoPage: null
    property Item commentsPage: null
    property Item relatedPage: null

    function setVideo(videoObject) {
        infoPage = tabGroup.addTab(Qt.resolvedUrl("DMDescriptionPage.qml"), 0);
        infoPage.setVideo(videoObject);
    }

    function loadComments() {
        commentsPage = tabGroup.addTab(Qt.resolvedUrl("DMCommentsPage.qml"), 1);
        commentsPage.setCommentsFeed(infoPage.video.videoId);
    }

    function loadRelated() {
        relatedPage = tabGroup.addTab(Qt.resolvedUrl("DMRelatedVideosPage.qml"), 2);
        relatedPage.setVideoFeed("https://api.dailymotion.com/video/" + infoPage.video.id + "/related?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS);
    }

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    Connections {
        target: Dailymotion
        onAddedToFavourites: if (pageStack.currentPage == root) infoPage.checkIfFavourite(infoPage.video.id);
        onDeletedFromFavourites: if (pageStack.currentPage == root) infoPage.checkIfFavourite(infoPage.video.id);
    }

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                text: qsTr("Info")
                checked: tabGroup.currentTab == infoPage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                text: (infoPage === null) || (!infoPage.video.comments_total) ? qsTr("Comments") : qsTr("Comments") + " (" + infoPage.video.comments_total.toString() + ")"
                checked: tabGroup.currentTab == commentsPage
                onClicked: if (commentsPage === null) loadComments(); else tabGroup.setTab(1);
            },

            TabButton {
                text: qsTr("Related")
                checked: tabGroup.currentTab == relatedPage
                onClicked: if (relatedPage === null) loadRelated(); else tabGroup.setTab(2);
            }
        ]
    }
}

